<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

$product_id = $product->get_id();
// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
} ?>

<li
    <?php wc_product_class('', $product); ?>>
    <?php
    /**
     * Hook: woocommerce_before_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_open - 10
     */
    /**
     * Hook: woocommerce_before_shop_loop_item_title.
     *
     * @hooked woocommerce_show_product_loop_sale_flash - 10
     * @hooked woocommerce_template_loop_product_thumbnail - 10
     */ ?>
    <div class="img_wrap">
        <?php
        if ($product->is_on_sale()) {
            $regular_price = (float)$product->get_regular_price();
            $sale_price = (float)$product->get_sale_price();

            if ($regular_price && $sale_price) {
                // Calculăm procentul de reducere
                $percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                echo '<span class="onsale">-' . $percentage . '% OFF</span>';
            }
        }

        ?>
        <?php global $product;
        $image_url = wp_get_attachment_url($product->get_image_id());
        ?>

        <a href="<?php echo esc_url($image_url); ?>" data-lightbox="product-gallery<?= $product_id ?>">
            <?php echo woocommerce_get_product_thumbnail(); ?>
        </a>
        <?php
        $quantity_in_cart = 0;
        foreach (WC()->cart->get_cart() as $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                $quantity_in_cart = $cart_item['quantity'];
                break;
            }
        }

        if ($quantity_in_cart > 0) { ?>
            <div class="product_notification_wrap active" data-product_id="<?php echo $product_id ?>">
                <div class="product-notification">
                    <?php echo pll_e('Aveți') ?>
                    <b>&nbsp<?php echo $quantity_in_cart ?></b>&nbsp<?php echo pll_e('produse în coș.') ?>
                </div>
                <button class="remove-from-cart-button custom_remove_button close" data-product_id="<?= $product_id ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M19.2807 18.2193C19.3504 18.289 19.4056 18.3717 19.4433 18.4628C19.4811 18.5538 19.5005 18.6514 19.5005 18.7499C19.5005 18.8485 19.4811 18.9461 19.4433 19.0371C19.4056 19.1281 19.3504 19.2109 19.2807 19.2806C19.211 19.3502 19.1283 19.4055 19.0372 19.4432C18.9462 19.4809 18.8486 19.5003 18.7501 19.5003C18.6515 19.5003 18.5539 19.4809 18.4629 19.4432C18.3718 19.4055 18.2891 19.3502 18.2194 19.2806L12.0001 13.0602L5.78068 19.2806C5.63995 19.4213 5.44907 19.5003 5.25005 19.5003C5.05103 19.5003 4.86016 19.4213 4.71943 19.2806C4.5787 19.1398 4.49963 18.949 4.49963 18.7499C4.49963 18.5509 4.5787 18.36 4.71943 18.2193L10.9397 11.9999L4.71943 5.78055C4.5787 5.63982 4.49963 5.44895 4.49963 5.24993C4.49963 5.05091 4.5787 4.86003 4.71943 4.7193C4.86016 4.57857 5.05103 4.49951 5.25005 4.49951C5.44907 4.49951 5.63995 4.57857 5.78068 4.7193L12.0001 10.9396L18.2194 4.7193C18.3602 4.57857 18.551 4.49951 18.7501 4.49951C18.9491 4.49951 19.1399 4.57857 19.2807 4.7193C19.4214 4.86003 19.5005 5.05091 19.5005 5.24993C19.5005 5.44895 19.4214 5.63982 19.2807 5.78055L13.0604 11.9999L19.2807 18.2193Z"
                              fill="#F20030"/>
                    </svg>
                </button>
            </div>
        <?php } else { ?>
            <div class="product_notification_wrap" data-product_id="<?php echo $product_id ?>">
                <div class="product-notification">
                    <?php echo pll_e('Aveți') ?>
                    <b>nbsp;<?php echo $quantity_in_cart ?></b>&nbsp<?php echo pll_e('produse în coș.') ?>
                </div>
                <button class="remove-from-cart-button custom_remove_button close" data-product_id="<?= $product_id ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M19.2807 18.2193C19.3504 18.289 19.4056 18.3717 19.4433 18.4628C19.4811 18.5538 19.5005 18.6514 19.5005 18.7499C19.5005 18.8485 19.4811 18.9461 19.4433 19.0371C19.4056 19.1281 19.3504 19.2109 19.2807 19.2806C19.211 19.3502 19.1283 19.4055 19.0372 19.4432C18.9462 19.4809 18.8486 19.5003 18.7501 19.5003C18.6515 19.5003 18.5539 19.4809 18.4629 19.4432C18.3718 19.4055 18.2891 19.3502 18.2194 19.2806L12.0001 13.0602L5.78068 19.2806C5.63995 19.4213 5.44907 19.5003 5.25005 19.5003C5.05103 19.5003 4.86016 19.4213 4.71943 19.2806C4.5787 19.1398 4.49963 18.949 4.49963 18.7499C4.49963 18.5509 4.5787 18.36 4.71943 18.2193L10.9397 11.9999L4.71943 5.78055C4.5787 5.63982 4.49963 5.44895 4.49963 5.24993C4.49963 5.05091 4.5787 4.86003 4.71943 4.7193C4.86016 4.57857 5.05103 4.49951 5.25005 4.49951C5.44907 4.49951 5.63995 4.57857 5.78068 4.7193L12.0001 10.9396L18.2194 4.7193C18.3602 4.57857 18.551 4.49951 18.7501 4.49951C18.9491 4.49951 19.1399 4.57857 19.2807 4.7193C19.4214 4.86003 19.5005 5.05091 19.5005 5.24993C19.5005 5.44895 19.4214 5.63982 19.2807 5.78055L13.0604 11.9999L19.2807 18.2193Z"
                              fill="#F20030"/>
                    </svg>
                </button>
            </div>
        <?php } ?>
    </div>

    <a href="<?php the_permalink(); ?>" class="content_wrap">
        <?php
        do_action('woocommerce_shop_loop_item_title'); ?>
		<?php
        if ($product && method_exists($product, 'get_bundled_items')) {
            $bundled_items = $product->get_bundled_items();
            if (!empty($bundled_items)) {

                $total_qty = 0;

                foreach ($bundled_items as $bundled_item) {

                    $bundled_product_qty = $bundled_item->get_quantity(); // cantitatea per bundle

                    $total_qty += $bundled_product_qty;
                } ?>

                <?php
                $total_weight = $total_qty * 0.9;
                ?>
                <p><b><?php echo pll_e('Greutate:') ?></b> <?= $total_weight ?> kg</p>
            <?php }
        } else { ?>

            <?php
            $price = $product->get_price();
            $boxPrice = $price / 9;
            $kgPrice = $boxPrice;
            ?>
            <p> 900g (100g = <?= round($kgPrice, '2'); ?> <?= get_woocommerce_currency() ?>)</p>
        <?php } ?>
<!--         <?php $price = $product->get_price();
        $boxPrice = $price / 9;
        $kgPrice = $boxPrice * 10;
        ?>
        <p>900g (100g / <?= round($boxPrice, '2') ?>€)</p> -->
        <?php

        /**
         * Hook: woocommerce_after_shop_loop_item_title.
         *
         * @hooked woocommerce_template_loop_rating - 5
         * @hooked woocommerce_template_loop_price - 10
         */ ?>
        <div class="short_desc">
            <?php the_excerpt(); ?>
        </div>
        <div class="images">
            <?php
            $tags = wp_get_post_terms($product_id, 'product_tag');

            // Verifică fiecare etichetă și afișează iconița corespunzătoare
            foreach ($tags as $tag) {
                $icon = get_field('tag_image', $tag);

                if ($icon) {
                    echo '<img src="' . esc_url($icon) . '" alt="' . esc_attr($tag->name) . '" class="product-icon"/>';
                }
            } ?>
            <img src="/wp-content/themes/victor-child/assets/img/freez.svg" alt="freez.svg">
        </div>
    </a>

    <div class="price_wrap">
        <span class="price_label"><?php echo pll_e('Preț per bucată:') ?></span>
        <?php do_action('woocommerce_after_shop_loop_item_title');
        $stock_quantity = $product->get_stock_quantity();

        // now we can print product stock quantity or do whatever
        ?>
        <?php
        if ($product->is_in_stock()) : ?>
            <p class='stock'><span><?php pll_e('În stoc'); ?></span></p>
        <?php else : ?>
            <p class="outofstock stock"><span><?php pll_e('Nu este în stoc'); ?></span></p>
        <?php endif; ?>

        <div class="add_quantity">
            <p><?php echo pll_e('Cantitate') ?></p>
            <div class="buttons">
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="1"
                        data-stock="<?php echo $stock_quantity; ?>">+1
                </button>
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="2"
                        data-stock="<?php echo $stock_quantity; ?>">+2
                </button>
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="3"
                        data-stock="<?php echo $stock_quantity; ?>">+3
                </button>
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="4"
                        data-stock="<?php echo $stock_quantity; ?>">+4
                </button>
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="5"
                        data-stock="<?php echo $stock_quantity; ?>">+5
                </button>
                <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="10"
                        data-stock="<?php echo $stock_quantity; ?>">+10
                </button>
            </div>
        </div>
        <div class="product-quantity-display">
            <button class="quantity-minus" data-product-id="<?php echo esc_attr($product_id) ?>">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M3.74972 12.7495C3.33578 12.7495 3 12.4137 3 11.9997C3 11.5858 3.33578 11.25 3.74972 11.25H20.2495C20.6634 11.25 20.9992 11.5858 20.9992 11.9997C20.9992 12.4137 20.6634 12.7495 20.2495 12.7495H3.74972Z"
                          fill="white"/>
                </svg>
            </button>
            <input type="text" data-id="quantity_<?php echo esc_attr($product_id) ?>" value="<?= $quantity_in_cart ?>"
                   readonly>
            <button class="quantity-plus" data-product-id="<?php echo esc_attr($product_id) ?>">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M3.74973 12.7493C3.33578 12.7493 3 12.4135 3 11.9996C3 11.5857 3.33578 11.2499 3.74973 11.2499H11.2499V3.74973C11.2499 3.33578 11.5857 3 11.9996 3C12.4135 3 12.7493 3.33578 12.7493 3.74973V11.2499H20.2495C20.6634 11.2499 20.9992 11.5857 20.9992 11.9996C20.9992 12.4135 20.6634 12.7493 20.2495 12.7493H12.7493V20.2495C12.7493 20.6634 12.4135 20.9992 11.9996 20.9992C11.5857 20.9992 11.2499 20.6634 11.2499 20.2495V12.7493H3.74973Z"
                          fill="white"/>
                </svg>
            </button>
        </div>
        <div class="subtotal_notification stock_notification" data-product_id="<?php echo $product_id ?>">
            <p><?php echo pll_e('încercare nereuşită!') ?></p>
            <p><?php echo pll_e('Nu poți adăuga mai mult de') ?>
                <b class="stock_quantity"> </b> <?php echo pll_e('unități.') ?> <?php echo pll_e('În coș ai deja') ?>
                <b class="in_cart"> </b> <?php echo pll_e('unități.') ?></p>
        </div>
        <?php if ($quantity_in_cart > 0) {
            $currency = get_woocommerce_currency();
            ?>
            <div class="subtotal_notification subtotal" data-product_id="<?php echo $product_id ?>">
                <p><?php echo pll_e('Cat te costă acest produs?') ?></p>
                <ul class="subtotal">
                    <li class="quantity"><?= $quantity_in_cart ?></li>
                    <li>&nbsp;x&nbsp;</li>
                    <li class="price_unit"><?= $price ?></li>
                    <li>&nbsp;=&nbsp;</li>
                    <li class="price"><b><?php echo $quantity_in_cart * $price ?>&nbsp;<?= $currency ?></b></li>
                </ul>
            </div>
        <?php } else {
            $currency = get_woocommerce_currency();
            ?>
            <div class="subtotal_notification subtotal" data-product_id="<?php echo $product_id ?>">
                <p><?php echo pll_e('Cat te costă acest produs?') ?></p>
                <ul class="subtotal">
                    <li class="quantity"><?= $quantity_in_cart ?></li>
                    <li>&nbsp;x&nbsp;</li>
                    <li class="price_unit"><?= $price ?></li>
                    <li>&nbsp;=&nbsp;</li>
                    <li class="price"><b><?php echo $quantity_in_cart * $price ?>&nbsp; <?= $currency ?></b></li>
                </ul>
            </div>
        <?php } ?>
        <?php /**
         * Hook: woocommerce_after_shop_loop_item.
         *
         * @hooked woocommerce_template_loop_product_link_close - 5
         * @hooked woocommerce_template_loop_add_to_cart - 10
         */
        //        do_action('woocommerce_after_shop_loop_item');
        ?>
</li>
