<?php
/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_mini_cart'); ?>

<?php if (!WC()->cart->is_empty()) : ?>

    <div id="free-shipping-progress" style="margin-bottom: 20px; display: flex; align-items: center; flex-wrap: wrap">
        <p id="free-shipping-message"
           style="font-weight: bold; font-family: 'Nunito Sans'; text-align: left; margin-bottom: 5px; width: 100%;"></p>
        <div style="background: #ffffff; height: 10px; border-radius: 10px; overflow: hidden; width: calc(100% - 35px); border: 1px solid rgb(255, 136, 0);  margin-right: 10px;">
            <div id="free-shipping-bar"
                 style="background: rgb(255, 136, 0); height: 100%; width: 0%; transition: width 0.5s;">
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" fill="rgb(255, 136, 0)" width="25px" height="25px" viewBox="0 0 32 32">
            <path d="M 0 6 L 0 8 L 19 8 L 19 23 L 12.84375 23 C 12.398438 21.28125 10.851563 20 9 20 C 7.148438 20 5.601563 21.28125 5.15625 23 L 4 23 L 4 18 L 2 18 L 2 25 L 5.15625 25 C 5.601563 26.71875 7.148438 28 9 28 C 10.851563 28 12.398438 26.71875 12.84375 25 L 21.15625 25 C 21.601563 26.71875 23.148438 28 25 28 C 26.851563 28 28.398438 26.71875 28.84375 25 L 32 25 L 32 16.84375 L 31.9375 16.6875 L 29.9375 10.6875 L 29.71875 10 L 21 10 L 21 6 Z M 1 10 L 1 12 L 10 12 L 10 10 Z M 21 12 L 28.28125 12 L 30 17.125 L 30 23 L 28.84375 23 C 28.398438 21.28125 26.851563 20 25 20 C 23.148438 20 21.601563 21.28125 21.15625 23 L 21 23 Z M 2 14 L 2 16 L 8 16 L 8 14 Z M 9 22 C 10.117188 22 11 22.882813 11 24 C 11 25.117188 10.117188 26 9 26 C 7.882813 26 7 25.117188 7 24 C 7 22.882813 7.882813 22 9 22 Z M 25 22 C 26.117188 22 27 22.882813 27 24 C 27 25.117188 26.117188 26 25 26 C 23.882813 26 23 25.117188 23 24 C 23 22.882813 23.882813 22 25 22 Z"></path>
        </svg>
    </div>
    <script>
        jQuery(document).ready(function ($) {
            function updateProgressBar() {
                let freeShippingLimit = 120;
                let cartTotal = <?php echo WC()->cart->get_displayed_subtotal(); ?>;
                let remaining = freeShippingLimit - cartTotal;
                let percentage = Math.min((cartTotal / freeShippingLimit) * 100, 100);

                $('#free-shipping-bar').css('width', percentage + '%');

                if (cartTotal >= freeShippingLimit) {
                    $('#free-shipping-message').text('🎉 <?php echo pll__("Felicitări! Ai transport gratuit!"); ?>');
                } else {
                    $('#free-shipping-message').text('<?php echo pll__("Mai adaugă în coș de"); ?> ' + remaining.toFixed(2) + '€ <?php echo pll__("și beneficiezi de transport gratuit!"); ?>');
                }
            }

            updateProgressBar();

            // Recalculează dacă coșul se actualizează (ex: AJAX update)
            $('body').on('updated_cart_totals', function () {
                updateProgressBar();
            });
        });
    </script>
    <ul class="woocommerce-mini-cart cart_list product_list_widget <?php echo esc_attr($args['list_class']); ?>">
        <?php
        do_action('woocommerce_before_mini_cart_contents');

        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
            $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

            if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
                /**
                 * This filter is documented in woocommerce/templates/cart/cart.php.
                 *
                 * @since 2.1.0
                 */
                $product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
                $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
                $product_price = apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key);
                $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                ?>
                <li class="woocommerce-mini-cart-item <?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>"
                    data-product-id="<?php echo esc_attr($product_id) ?>">
                    <?php
                    echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        'woocommerce_cart_item_remove_link',
                        sprintf(
                            '<a href="%s" class="custom_remove_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s" data-success_message="%s">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                             <path d="M15.5306 9.53063L13.0603 12L15.5306 14.4694C15.6003 14.5391 15.6556 14.6218 15.6933 14.7128C15.731 14.8039 15.7504 14.9015 15.7504 15C15.7504 15.0985 15.731 15.1961 15.6933 15.2872C15.6556 15.3782 15.6003 15.4609 15.5306 15.5306C15.4609 15.6003 15.3782 15.6556 15.2872 15.6933C15.1961 15.731 15.0986 15.7504 15 15.7504C14.9015 15.7504 14.8039 15.731 14.7128 15.6933C14.6218 15.6556 14.5391 15.6003 14.4694 15.5306L12 13.0603L9.53063 15.5306C9.46095 15.6003 9.37822 15.6556 9.28718 15.6933C9.19613 15.731 9.09855 15.7504 9 15.7504C8.90146 15.7504 8.80388 15.731 8.71283 15.6933C8.62179 15.6556 8.53906 15.6003 8.46938 15.5306C8.3997 15.4609 8.34442 15.3782 8.30671 15.2872C8.269 15.1961 8.24959 15.0985 8.24959 15C8.24959 14.9015 8.269 14.8039 8.30671 14.7128C8.34442 14.6218 8.3997 14.5391 8.46938 14.4694L10.9397 12L8.46938 9.53063C8.32865 9.38989 8.24959 9.19902 8.24959 9C8.24959 8.80098 8.32865 8.61011 8.46938 8.46937C8.61011 8.32864 8.80098 8.24958 9 8.24958C9.19903 8.24958 9.3899 8.32864 9.53063 8.46937L12 10.9397L14.4694 8.46937C14.5391 8.39969 14.6218 8.34442 14.7128 8.3067C14.8039 8.26899 14.9015 8.24958 15 8.24958C15.0986 8.24958 15.1961 8.26899 15.2872 8.3067C15.3782 8.34442 15.4609 8.39969 15.5306 8.46937C15.6003 8.53906 15.6556 8.62178 15.6933 8.71283C15.731 8.80387 15.7504 8.90145 15.7504 9C15.7504 9.09855 15.731 9.19613 15.6933 9.28717C15.6556 9.37822 15.6003 9.46094 15.5306 9.53063ZM21.75 12C21.75 13.9284 21.1782 15.8134 20.1068 17.4168C19.0355 19.0202 17.5127 20.2699 15.7312 21.0078C13.9496 21.7458 11.9892 21.9389 10.0979 21.5627C8.20656 21.1865 6.46928 20.2579 5.10571 18.8943C3.74215 17.5307 2.81355 15.7934 2.43735 13.9021C2.06114 12.0108 2.25422 10.0504 2.99218 8.26884C3.73013 6.48726 4.97982 4.96451 6.58319 3.89317C8.18657 2.82183 10.0716 2.25 12 2.25C14.585 2.25273 17.0634 3.28084 18.8913 5.10872C20.7192 6.93661 21.7473 9.41498 21.75 12ZM20.25 12C20.25 10.3683 19.7661 8.77325 18.8596 7.41655C17.9531 6.05984 16.6646 5.00242 15.1571 4.37799C13.6497 3.75357 11.9909 3.59019 10.3905 3.90852C8.79017 4.22685 7.32016 5.01259 6.16637 6.16637C5.01259 7.32015 4.22685 8.79016 3.90853 10.3905C3.5902 11.9908 3.75358 13.6496 4.378 15.1571C5.00242 16.6646 6.05984 17.9531 7.41655 18.8596C8.77326 19.7661 10.3683 20.25 12 20.25C14.1873 20.2475 16.2843 19.3775 17.8309 17.8309C19.3775 16.2843 20.2475 14.1873 20.25 12Z" fill="#222222"/>
                                        </svg>
                                    </a>',
                            esc_url(wc_get_cart_remove_url($cart_item_key)),
                            /* translators: %s is the product name */
                            esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
                            esc_attr($product_id),
                            esc_attr($cart_item_key),
                            esc_attr($_product->get_sku()),
                            /* translators: %s is the product name */
                            esc_attr(sprintf(__('&ldquo;%s&rdquo; has been removed from your cart', 'woocommerce'), wp_strip_all_tags($product_name)))
                        ),
                        $cart_item_key
                    );
                    ?>
                    <?php if (empty($product_permalink)) : ?>
                        <?php echo $thumbnail . wp_kses_post($product_name); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    <?php else : ?>
                        <a href="<?php echo esc_url($product_permalink); ?>" class="mini_cart_item_image_wrap">
                            <?php echo $thumbnail; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        </a>
                    <?php endif; ?>
                    <div class="mini_car_item_content">
                        <a href="<?php echo esc_url($product_permalink); ?>"><?php echo wp_kses_post($product_name) ?> </a>
                        <?php echo wc_get_formatted_cart_item_data($cart_item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <!--                        --><?php //echo apply_filters('woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf('%s &times; %s', $cart_item['quantity'], $product_price) . '</span>', $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <div class="quantity_wrap">
                            <div class="quantity">
                                <button class="button minus quantity-minus"
                                        data-product-id="<?php echo esc_attr($product_id) ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13"
                                         fill="none">
                                        <path d="M1.87486 6.87473C1.66789 6.87473 1.5 6.70683 1.5 6.49986C1.5 6.29289 1.66789 6.125 1.87486 6.125H10.1247C10.3317 6.125 10.4996 6.29289 10.4996 6.49986C10.4996 6.70683 10.3317 6.87473 10.1247 6.87473H1.87486Z"
                                              fill="#222222"/>
                                    </svg>
                                </button>
                                <input type="number" readonly data-id="quantity_<?php echo esc_attr($product_id) ?>"
                                       value="<?= $cart_item['quantity'] ?>">
                                <button class="button plus quantity-plus mini_cart_plus"
                                        data-product-id="<?php echo esc_attr($product_id) ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13"
                                         fill="none">
                                        <path d="M1.87486 6.87466C1.66789 6.87466 1.5 6.70677 1.5 6.4998C1.5 6.29283 1.66789 6.12494 1.87486 6.12494H5.62494V2.37486C5.62494 2.16789 5.79283 2 5.9998 2C6.20677 2 6.37466 2.16789 6.37466 2.37486V6.12494H10.1247C10.3317 6.12494 10.4996 6.29283 10.4996 6.4998C10.4996 6.70677 10.3317 6.87466 10.1247 6.87466H6.37466V10.6247C6.37466 10.8317 6.20677 10.9996 5.9998 10.9996C5.79283 10.9996 5.62494 10.8317 5.62494 10.6247V6.87466H1.87486Z"
                                              fill="#222222"/>
                                    </svg>
                                </button>
                            </div>
                            <p> <?= sprintf('&times; %s ', $product_price) ?></p>
                        </div>
                        <div class="mini_cart_subtotal subtotal_notification"
                             data-product_id="<?php echo $product_id ?>">
                            <ul>
                                <li class="price">
                                    <b><?= wc_price($cart_item['line_subtotal'] + $cart_item['line_subtotal_tax']); ?></b>
                                </li>
                            </ul>

                        </div>
                    </div>
                </li>
                <?php
            }
        }

        do_action('woocommerce_mini_cart_contents');
        ?>
    </ul>

    <p class="woocommerce-mini-cart__total total">
        <?php
        /**
         * Hook: woocommerce_widget_shopping_cart_total.
         *
         * @hooked woocommerce_widget_shopping_cart_subtotal - 10
         */
        do_action('woocommerce_widget_shopping_cart_total');
        ?>
    </p>

    <?php do_action('woocommerce_widget_shopping_cart_before_buttons'); ?>

    <p class="woocommerce-mini-cart__buttons buttons">
        <?php do_action('woocommerce_widget_shopping_cart_buttons'); ?>
        <span class="min_order_message"><?php echo pll__('Mindestbestellwert €60,00') ?></span>
    </p>

    <?php do_action('woocommerce_widget_shopping_cart_after_buttons'); ?>

<?php else : ?>

    <p class="woocommerce-mini-cart__empty-message"><?php echo pll_e('Nu sunt produse în coş') ?></p>

<?php endif; ?>

<?php do_action('woocommerce_after_mini_cart'); ?>
