<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();

if (have_posts()) {
?>
<div class="custom_search_page">
    <header class="page-header alignwide">
        <h1 class="page-title">
            <?php
            printf(
            /* translators: %s: Search term. */
                esc_html__('Rezultate pentru "%s"', 'twentytwentyone'),
                '<span class="page-description search-term">' . esc_html(get_search_query()) . '</span>'
            );
            ?>
        </h1>
    </header><!-- .page-header -->

    <div class="search-result-count default-max-width">
        <?php
        printf(
            esc_html(
            /* translators: %d: The number of search results. */
                _n(
                    'We found %d result for your search.',
                    'We found %d results for your search.',
                    (int)$wp_query->found_posts,
                    'twentytwentyone'
                )
            ),
            (int)$wp_query->found_posts
        );
        ?>
    </div><!-- .search-result-count -->
    <?php if (have_posts()) : ?>
        <div class="search-results">
            <?php while (have_posts()) : the_post(); ?>
                <?php
                // Verifică dacă postarea este un anunț AWPCP
                if ('awpcp_listing' === get_post_type()) {
                    ?>
                    <div class="awpcp-listing">

                        <!-- Afișează imaginea anunțului -->
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="listing-thumbnail">
                                <?php the_post_thumbnail('medium'); ?>
                            </div>
                        <?php endif; ?>
                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

                        <!-- Afișează prețul anunțului -->
                        <?php
                        $price = get_post_meta(get_the_ID(), '_awpcp_price', true);
                        $price = $price / 100;
                        if ($price) {
                            echo '<p class="price">' . $price . ' €</p>';
                        }
                        ?>
                    </div>
                    <?php
                } else {
                    // Afișează alte postări obișnuite
                    ?>
                    <div class="regular-search-result">
                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <p><?php the_excerpt(); ?></p>
                    </div>
                    <?php
                }
                ?>
            <?php endwhile; ?>
        </div>
    <?php else : ?>
        <p><?php _e('No results found.', 'tema-ta'); ?></p>

    <?php endif;
    } ?>
    <a href="/anunturi/cauta-anunturi/" class="back_to_search">Înapoi la căutare</a>
</div>

<?php get_footer(); ?>
