<?php
/**
 * Template name: Home
 * Template post type: page
 */
?>
<?php get_header() ?>
<div class="container_fluid">
    <?php get_template_part('main-slider'); ?>
</div>
<?php get_template_part('contact-bar'); ?>

<div class="container">
    <div class="why_promez_wrap" id="why_promez_wrap">
        <h2><?php the_field('why_promez_title'); ?></h2>
        <div class="why_promez">
            <?php if (have_rows('why_promez')):
                while (have_rows('why_promez')) : the_row(); ?>
                    <div class="block">
                        <img src="<?php the_sub_field('block_image'); ?>" alt="" loading="lazy">
                        <span><?php the_sub_field('block_title'); ?></span>
                        <p><?php the_sub_field('block_description'); ?></p>
                    </div>
                <?php endwhile;
            endif; ?>
        </div>
    </div>
</div>
<div class="mission_wrap" id="mission_wrap">
    <h2><?php the_field('mision_section_title') ?></h2>
    <div class="container">
        <div class="mission">
            <div class="left_side">
                <h3><?php the_field('mision_left_title') ?></h3>
                <p><?php the_field('mision_left_description') ?></p>
                <ul>
                    <li class="mission_tab active"><?php echo pll_e('Misiune') ?></li>
                    <li class="values_tab"><?php echo pll_e('Valori') ?></li>
                </ul>
            </div>
            <div class="right_side">
                <?php
                $tab_image = get_field('mision_image');
                $size = 'large'; // (thumbnail, medium, large, full or custom size)
                if ($tab_image) { ?>

                    <div class="mission_tab tab_content active"
                         style="background-image: url('<?php echo wp_get_attachment_image_url($tab_image, $size); ?>')">
                        <div class="descriere">
                            <?php the_field('mision_description') ?>
                        </div>
                    </div>
                <?php } ?>

                <?php
                $tab_image = get_field('values_image');
                $size = 'large'; // (thumbnail, medium, large, full or custom size)
                if ($tab_image) { ?>
                    <div class="values_tab tab_content "
                         style="background-image: url('<?php echo wp_get_attachment_image_url($tab_image, $size); ?>')">
                        <div class="descriere">
                            <?php the_field('values_description') ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<div class="container">
    <!--    <div class="factory_wrap" id="factory_wrap">-->
    <!--        <div class="factory">-->
    <!--            <div class="left_side">-->
    <!--                <h2>--><?php //the_field('factory_title') ?><!--</h2>-->
    <!--                <div class="slide_desc">--><?php //the_field('factory_description') ?><!--</div>-->
    <!--                <img src="/wp-content/themes/victor-child/assets/img/ifs.svg" alt="">-->
    <!--            </div>-->
    <!--            <div class="right_side">-->
    <!--                <div class="slide">-->
    <!--                    --><?php //if (have_rows('factory_slides')):
    //                        while (have_rows('factory_slides')) : the_row(); ?>
    <!--                            <div>-->
    <!--                                <div class="img_wrap">-->
    <!--                                    <img src="--><?php //the_sub_field('slide_image') ?><!--" alt="">-->
    <!--                                </div>-->
    <!--                            </div>-->
    <!--                        --><?php //endwhile;
    //                    endif; ?>
    <!--                </div>-->
    <!--                <div class="custom_arrows_factory">-->
    <!--                    <div class="arrow arrow_prev">-->
    <!--                        <svg width="56" height="56" viewBox="0 0 56 56" fill="none"-->
    <!--                             xmlns="http://www.w3.org/2000/svg">-->
    <!--                            <path d="M0 8C0 3.58172 3.58172 0 8 0H48C52.4183 0 56 3.58172 56 8V48C56 52.4183 52.4183 56 48 56H8C3.58172 56 0 52.4183 0 48V8Z"-->
    <!--                                  fill="#222222" fill-opacity="0.75"/>-->
    <!--                            <g clip-path="url(#clip0_458_5909)">-->
    <!--                                <path d="M33.2958 38.4541C33.4004 38.5587 33.4833 38.6828 33.5399 38.8193C33.5964 38.9559 33.6255 39.1023 33.6255 39.2501C33.6255 39.3979 33.5964 39.5443 33.5399 39.6808C33.4833 39.8174 33.4004 39.9415 33.2958 40.046C33.1913 40.1505 33.0672 40.2335 32.9307 40.29C32.7941 40.3466 32.6477 40.3757 32.4999 40.3757C32.3521 40.3757 32.2057 40.3466 32.0691 40.29C31.9326 40.2335 31.8085 40.1505 31.704 40.046L20.454 28.796C20.3494 28.6915 20.2664 28.5675 20.2098 28.4309C20.1532 28.2943 20.124 28.1479 20.124 28.0001C20.124 27.8522 20.1532 27.7058 20.2098 27.5693C20.2664 27.4327 20.3494 27.3086 20.454 27.2041L31.704 15.9541C31.9151 15.743 32.2014 15.6245 32.4999 15.6245C32.7984 15.6245 33.0848 15.743 33.2958 15.9541C33.5069 16.1652 33.6255 16.4515 33.6255 16.7501C33.6255 17.0486 33.5069 17.3349 33.2958 17.546L22.8404 28.0001L33.2958 38.4541Z"-->
    <!--                                      fill="white"/>-->
    <!--                            </g>-->
    <!--                            <defs>-->
    <!--                                <clipPath id="clip0_458_5909">-->
    <!--                                    <rect width="36" height="36" fill="white" transform="translate(10 10)"/>-->
    <!--                                </clipPath>-->
    <!--                            </defs>-->
    <!--                        </svg>-->
    <!--                    </div>-->
    <!--                    <div class="arrow arrow_next">-->
    <!--                        <svg width="56" height="56" viewBox="0 0 56 56" fill="none"-->
    <!--                             xmlns="http://www.w3.org/2000/svg">-->
    <!--                            <path d="M0 8C0 3.58172 3.58172 0 8 0H48C52.4183 0 56 3.58172 56 8V48C56 52.4183 52.4183 56 48 56H8C3.58172 56 0 52.4183 0 48V8Z"-->
    <!--                                  fill="#222222" fill-opacity="0.75"/>-->
    <!--                            <g clip-path="url(#clip0_458_5909)">-->
    <!--                                <path d="M33.2958 38.4541C33.4004 38.5587 33.4833 38.6828 33.5399 38.8193C33.5964 38.9559 33.6255 39.1023 33.6255 39.2501C33.6255 39.3979 33.5964 39.5443 33.5399 39.6808C33.4833 39.8174 33.4004 39.9415 33.2958 40.046C33.1913 40.1505 33.0672 40.2335 32.9307 40.29C32.7941 40.3466 32.6477 40.3757 32.4999 40.3757C32.3521 40.3757 32.2057 40.3466 32.0691 40.29C31.9326 40.2335 31.8085 40.1505 31.704 40.046L20.454 28.796C20.3494 28.6915 20.2664 28.5675 20.2098 28.4309C20.1532 28.2943 20.124 28.1479 20.124 28.0001C20.124 27.8522 20.1532 27.7058 20.2098 27.5693C20.2664 27.4327 20.3494 27.3086 20.454 27.2041L31.704 15.9541C31.9151 15.743 32.2014 15.6245 32.4999 15.6245C32.7984 15.6245 33.0848 15.743 33.2958 15.9541C33.5069 16.1652 33.6255 16.4515 33.6255 16.7501C33.6255 17.0486 33.5069 17.3349 33.2958 17.546L22.8404 28.0001L33.2958 38.4541Z"-->
    <!--                                      fill="white"/>-->
    <!--                            </g>-->
    <!--                            <defs>-->
    <!--                                <clipPath id="clip0_458_5909">-->
    <!--                                    <rect width="36" height="36" fill="white" transform="translate(10 10)"/>-->
    <!--                                </clipPath>-->
    <!--                            </defs>-->
    <!--                        </svg>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!---->
    <!--    </div>-->
</div>
<div class="company_history_wrap" id="company_history_wrap">
    <h2><?php echo pll_e('Istoria Promez') ?></h2>
    <div class="container">
        <div class="company_history">
            <div class="top_slider">
                <?php
                if (have_rows('promez_history')):
                    while (have_rows('promez_history')) : the_row(); ?>
                        <div>
                            <div class="slide">
                                <div class="slide_image">
                                    <?php $image_id = get_sub_field('year_image') ?>
                                    <?php echo wp_get_attachment_image($image_id, 'full'); ?>

                                    <span><?php the_sub_field('year') ?></span>
                                </div>
                                <div class="slide_title">
                                    <?php the_sub_field('year_title') ?>
                                </div>
                                <div class="slide_description">
                                    <?php the_sub_field('year_description') ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                endif; ?>
            </div>
            <div class="nav_slide_wrap">
                <div class="nav_slide">
                    <?php
                    if (have_rows('promez_history')):
                        while (have_rows('promez_history')) : the_row(); ?>
                            <div>
                                <div class="slide">
                                    <span><?php the_sub_field('year') ?></span>
                                    <div class="slide_title">
                                        <?php the_sub_field('year_title') ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                    endif; ?>
                </div>
                <div class="custom_arrows_history">
                    <div class="arrow prev_arrow_history">
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none">
                            <path d="M38.8261 47.4235C39.0003 47.5977 39.1385 47.8045 39.2328 48.0321C39.327 48.2598 39.3756 48.5037 39.3756 48.7501C39.3756 48.9964 39.327 49.2404 39.2328 49.468C39.1385 49.6956 39.0003 49.9024 38.8261 50.0766C38.6519 50.2508 38.4451 50.389 38.2175 50.4833C37.9898 50.5776 37.7459 50.6261 37.4995 50.6261C37.2532 50.6261 37.0092 50.5776 36.7816 50.4833C36.554 50.389 36.3472 50.2508 36.173 50.0766L17.423 31.3266C17.2486 31.1525 17.1103 30.9457 17.016 30.7181C16.9216 30.4905 16.873 30.2465 16.873 30.0001C16.873 29.7537 16.9216 29.5097 17.016 29.2821C17.1103 29.0544 17.2486 28.8476 17.423 28.6735L36.173 9.9235C36.5248 9.57168 37.002 9.37402 37.4995 9.37402C37.9971 9.37402 38.4743 9.57168 38.8261 9.9235C39.1779 10.2753 39.3756 10.7525 39.3756 11.2501C39.3756 11.7476 39.1779 12.2248 38.8261 12.5766L21.4003 30.0001L38.8261 47.4235Z"
                                  fill="#222222"/>
                        </svg>
                    </div>
                    <div class="arrow next_arrow_history">
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none">
                            <path d="M21.1739 12.5765C20.9997 12.4023 20.8615 12.1955 20.7672 11.9679C20.673 11.7402 20.6244 11.4963 20.6244 11.2499C20.6244 11.0036 20.673 10.7596 20.7672 10.532C20.8615 10.3044 20.9997 10.0976 21.1739 9.92336C21.3481 9.74916 21.5549 9.61097 21.7826 9.51669C22.0102 9.42241 22.2541 9.37388 22.5005 9.37388C22.7468 9.37388 22.9908 9.42241 23.2184 9.51669C23.446 9.61097 23.6528 9.74916 23.827 9.92336L42.577 28.6734C42.7514 28.8475 42.8897 29.0543 42.984 29.2819C43.0784 29.5095 43.127 29.7535 43.127 29.9999C43.127 30.2463 43.0784 30.4903 42.984 30.7179C42.8897 30.9456 42.7514 31.1524 42.577 31.3265L23.827 50.0765C23.4752 50.4283 22.998 50.626 22.5005 50.626C22.0029 50.626 21.5257 50.4283 21.1739 50.0765C20.8221 49.7247 20.6244 49.2475 20.6244 48.7499C20.6244 48.2524 20.8221 47.7752 21.1739 47.4234L38.5997 29.9999L21.1739 12.5765Z"
                                  fill="#222222"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="home_product_wrap" id="home_product_wrap">
    <h2><?php the_field('product_section_title') ?></h2>
    <p><?php the_field('product_section_description') ?></p>
    <div class="container">
        <div class="home_products">
            <?php
            // Interogare pentru produse featured
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => 6, // Poți schimba numărul de produse afișate
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field' => 'name',
                        'terms' => 'featured',
                        'operator' => 'IN',
                    ),
                ),
            );

            $featured_products = new WP_Query($args);
            if ($featured_products->have_posts()) : ?>
                <?php while ($featured_products->have_posts()) : $featured_products->the_post();
                    global $product; ?>
                    <div class="featured_product">
                        <a href="<?php the_permalink(); ?>" class="img_wrap">
                            <?php echo woocommerce_get_product_thumbnail('full'); // Afișează imaginea produsului ?>
                        </a>
                        <h4><?php the_title(); // Afișează titlul produsului ?></h4>
                        <p><?php echo get_the_excerpt() ?></p>
                        <a href="<?php the_permalink(); ?>" class="button"><?php echo pll_e('Cumpără acum') ?></a>
                    </div>

                <?php endwhile; ?>
            <?php else : ?>
                <p>Nu există produse featured disponibile.</p>
            <?php endif;
            // Resetează postdata pentru a evita conflictele cu alte interogări
            wp_reset_postdata();
            ?>

        </div>
    </div>
    <a href="<?php echo pll_e('/magazin/') ?>" class="all_products"><?php echo pll_e('Magazin') ?></a>
</div>
<div class="home_recipes_wrap" id="home_recipes_wrap">
    <h2><?php the_field('recipes_section_title') ?></h2>
    <p><?php the_field('recipes_section_description') ?></p>
    <div class="home_recipes">
        <?php
        // Interogare pentru articole
        $args = array(
            'post_type' => 'post',  // Posturile de tip 'post' sunt articolele de pe blog
            'posts_per_page' => 5,      // Schimbă numărul de articole afișate după preferințe
            'orderby' => 'date',
            'order' => 'ASC',
        );

        $blog_posts = new WP_Query($args);
        if ($blog_posts->have_posts()) : ?>
            <div class="blog_posts">
                <?php while ($blog_posts->have_posts()) : $blog_posts->the_post(); ?>
                    <div class="blog_post">
                        <a href="<?php the_permalink(); ?>" class="img_wrap">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('full');
                            }
                            ?>
                        </a>
                        <h4><?php the_title(); ?></h4>
                        <div class="short_desc">
                            <p><?php echo get_the_excerpt() ?></p>
                        </div>
                        <div class="recipe_by">
                            <p><?php echo pll_e('Rețetă de') ?>&nbsp;</p>
                            <span><?php the_field('recipe_by') ?></span>
                        </div>
                        <!--                        <a href="-->
                        <?php //the_permalink(); ?><!--" class="button">Citește mai mult</a>-->
                    </div>

                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <p>Nu există articole disponibile.</p>
        <?php endif;
        wp_reset_postdata();
        ?>
    </div>
    <a href="<?php echo pll_e('/retete') ?>" class="more_recipes"><?php echo pll_e('Mai multe rețete') ?></a>
</div>
<?php get_template_part('section-newsletter'); ?>

<?php get_footer() ?>


