<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" href="/wp-content/themes/victor-child/style.css">
    <?php wp_head(); ?>
    <link rel="preload" as="image" href="https://promez.de/wp-content/uploads/2025/07/1800x860_01.webp" type="image/webp">
    <link rel="preload" as="image" href="https://promez.de/wp-content/uploads/2025/07/1800x860_02.webp" type="image/webp">
    <link rel="preload" as="image" href="https://promez.de/wp-content/uploads/2025/07/1800x860_03.webp" type="image/webp">
    <link rel="preload" as="image" href="https://promez.de/wp-content/uploads/2025/07/1800x860_04.webp" type="image/webp">
    <link rel="preload" as="image" href="https://promez.de/wp-content/uploads/2025/07/1800x860_05.webp" type="image/webp">
</head>
<noscript>
    <link rel="stylesheet" href="<?php echo esc_url(get_stylesheet_uri()); ?>">
</noscript>
<body <?php body_class(); ?>>
<div id="fb-root"></div>
<div id="fb-root"></div>
<script async defer crossorigin="anonymous"
        src="https://connect.facebook.net/ro_RO/sdk.js#xfbml=1&version=v21.0&appId=514272650267936"></script>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <?php get_template_part('template-parts/header/site-header'); ?>
    <div id="content" class="site-content">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
