<?php
/**
 * Template name: Careers
 * template post type: page
 */
?>
<?php get_header() ?>
<div class="faq_custom_header"></div>
<div class="careers">
    <div class="container">
        <h1><?php the_title() ?></h1>
        <div class="job_list">
            <?php if (have_rows('job')):
                while (have_rows('job')) : the_row(); ?>
                    <div class="job">
                        <div class="job_header">
                            <h3><?php the_sub_field('job_title') ?></h3>
                            <img src="/wp-content/themes/victor-child/assets/img/arrow-right_white.svg" loading="lazy"
                                 alt="arrow-right_white.svg">
                        </div>
                        <div class="job_content" id="test">
                            <div class="job_block">
                                <h5><?php echo pll_e('Responsabilități') ?></h5>
                                <div class="job_block_description">
                                    <?php the_sub_field('responsibilities') ?>
                                </div>
                            </div>
                            <div class="job_block">
                                <h5><?php echo pll_e('Cerințe') ?></h5>
                                <div class="job_block_description">
                                    <?php the_sub_field('requirements') ?>
                                </div>
                            </div>
                            <div class="job_block">
                                <h5><?php echo pll_e('Beneficii') ?></h5>
                                <div class="job_block_description">
                                    <?php the_sub_field('benefits') ?>
                                </div>
                            </div>
                            <img src="/wp-content/themes/victor-child/assets/img/contact.jpeg" class="job_image"  loading="lazy"
                                 alt="contact.jpeg">
                            <?php echo do_shortcode('[contact-form-7 id="7be1db6" title="Job CV"]') ?>
                        </div>
                    </div>
                <?php endwhile;
            endif; ?>
        </div>
    </div>
</div>
<div class="container">
    <div class="midd_section">
        <div class="img_side">
            <img src="/wp-content/themes/victor-child/assets/img/Content-carrer.png"  loading="lazy" alt="Content-carrer.png">
        </div>
        <div class="text_side">
            <h2><span>Promez:</span> <?php echo pll_e('Oferă') ?></h2>
            <p><?php echo pll_e('Promez oferă oportunități pentru dezvoltarea profesională la nivel internațional. Ca parte a echipei noastre, vei avea acces la o rețea de branduri de top din industrie, proiecte inovatoare și experiențe interculturale care îți vor îmbogăți cariera.') ?></p>
        </div>
    </div>
</div>
<div class="job_features_wrap">
    <h2><?php echo pll_e('Alătură-te echipei Promez!') ?></h2>
    <div class="container">
        <div class="job_features">
            <?php if (have_rows('job_features')):
                while (have_rows('job_features')) : the_row(); ?>
                    <div class="job_feature">
                        <div class="img_wrap">
                            <img src="<?php the_sub_field('feature_image') ?>" alt=""  loading="lazy">
                        </div>
                        <h6><?php the_sub_field('feature_title') ?></h6>
                        <p><?php the_sub_field('feature_description') ?></p>
                    </div>
                <?php endwhile;
            endif; ?>

        </div>
    </div>
</div>
<?php get_template_part('section-newsletter'); ?>

<?php get_footer() ?>
