jQuery(function ($) {
    let modalCreated = false;

    // Interceptează click pe butonul "Actualizează" (Update)
    $('#post').on('submit', function (e) {
        let newStatus = $('#order_status').val();
        if (newStatus === 'wc-completed' && !modalCreated) {
            e.preventDefault();

            // Modal simplu fără biblioteci
            let modal = $(`
                <div id="order-checklist-modal" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.6);z-index:9999;display:flex;align-items:center;justify-content:center;">
                    <div style="background:#fff;padding:20px;border-radius:8px;max-height:80vh;overflow:auto;width:400px;">
                        <h3>${orderChecklistData.modalTitle}</h3>
                        <ul style="list-style:none;padding-left:0;">
                            ${orderChecklistData.products.map((product, index) => `
                                <li>
                                    <label>
                                        <input type="checkbox" class="product-check" id="check_${index}">
                                        ${product.qty} × ${product.name}
                                    </label>
                                </li>
                            `).join('')}
                        </ul>
                        <br>
                        <button id="confirm-products" class="button button-primary">${orderChecklistData.confirmBtn}</button>
                    </div>
                </div>
            `);

            $('body').append(modal);
            modalCreated = true;

            $('#confirm-products').on('click', function () {
                let allChecked = $('.product-check').length === $('.product-check:checked').length;
                if (!allChecked) {
                    alert(orderChecklistData.alertText);
                } else {
                    $('#order-checklist-modal').remove();
                    modalCreated = false;
                    $('#post').submit(); // Trimite din nou formularul
                }
            });
        }
    });
});
