jQuery(function ($) {
    $(document).ready(function () {
        function checkMinimumAmount() {
            $.ajax({
                url: '/wp-admin/admin-ajax.php',
                method: 'GET',
                data: {
                    action: 'check_cart_minimum'
                },
                success: function (response) {
                    console.log(response.value)
                    if (response.min_reached) {
                        $('body').removeClass('min-order-not-reached');

                    } else {

                        $('body').addClass('min-order-not-reached');
                    }
                    // Afișează/ascunde mesajul lângă buton
                    showOrHideMinOrderMessage(response.min_reached, response.subtotal);
                }
            });
        }

        function showOrHideMinOrderMessage(minReached, subtotalText) {
            var $message = $('#min-order-warning');
            var $cart_button = $('.wc-block-cart__submit-button')
            var $target = $('.wc-block-cart__submit-container'); // containerul butonului de checkout

            if ($target.length && !$message.length) {
                // Creăm mesajul dacă nu există deja
                $message = $('<div id="min-order-warning"></div>');
                $target.append($message);
            }

            if (!minReached) {
                $message.html(minOrderCheck.message_below_min);
                $message.show();
                $cart_button.hide();
            } else {
                $message.hide();
                $cart_button.show();
            }
        }

        // Rulăm inițial
        checkMinimumAmount();

        // Când se actualizează coșul sau mini-cartul
        $('body').on('updated_cart_totals updated_wc_div', function () {
            checkMinimumAmount();
        });

        // Când se dau click pe plus/minus la cantitate (fallback)
        $('body').on('click', '.quantity-minus, .quantity-plus, .add-to-cart-button, .wc-block-components-quantity-selector__button--plus, .wc-block-components-quantity-selector__button--minus', function () {
            setTimeout(checkMinimumAmount, 1000);
        });
    });
});
