<?php
/**
 * @copyright 2010-2014 JTL-Software GmbH
 * @package jtl\Connector\Type
 */

namespace jtl\Connector\Type;

use \jtl\Connector\Type\PropertyInfo;

/**
 * @access public
 * @package jtl\Connector\Type
 */
class ProductWarehouseInfo extends DataType
{
    protected function loadProperties()
    {
        return [
            new PropertyInfo('productId', 'Identity', null, true, true, false),
            new PropertyInfo('warehouseId', 'Identity', null, true, true, false),
            new PropertyInfo('inflowQuantity', 'double', 0.0, false, false, false),
            new PropertyInfo('stockLevel', 'double', 0.0, false, false, false),
        ];
    }

    public function isMain()
    {
        return false;
    }
}
