<?php
/*
   Plugin Name: DPD Versandetikett Plugin WooCommerce
   Plugin URI: https://www.emoose.de/produkt/woocommerce-dpd-versandetikett-generator/
   Description: Erzeuge mit diesem Plugin direkt aus WooCommerce heraus DPD Versandetiketten fÃ¼r deine Kundenbestellungen. Mit nur einem Klick kannst du aus der Lieferadresse des Kunden ein DPD Paketaufkleber erstellen und ausdrucken.
   Version: 5.4.1
   Author: emoose GmbH
   Author URI: https://www.emoose.de
   WC tested up to: 10.3.3
   License: GPL2
   Text Domain: dpd-shipping-label
*/
//defined( 'ABSPATH' ) || exit;
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
error_reporting(0);

if ( ! defined( 'LURL' ) )
	define('LURL', 'https://www.emoose.de/');
	
if ( ! defined( 'REF' ) )
	define('REF', 'DPD');

if ( ! defined( 'DPD_TRACKING_URL' ) )
	define('DPD_TRACKING_URL', 'https://tracking.dpd.de/parcelstatus?query=PARCEL_NUMBER&locale=de_DE');

if(!class_exists('Puc_v4_Factory')){
	require plugin_dir_path(__FILE__).'/plugin-update-checker-master/plugin-update-checker.php';
}
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'http://test.emoose.de/dpd-shipping-label/update/?action=get_metadata&slug=dpd-shipping-label',
	__FILE__,
	'dpd-shipping-label'
);
$MyUpdateChecker->addQueryArgFilter('get_dpd_shipping_label_update');
function get_dpd_shipping_label_update($queryArgs) {
	$queryArgs['license_key'] = get_option('dpdl');
    return $queryArgs;
}
$dpd_file = plugin_basename( __FILE__ );
add_action( "in_plugin_update_message-$dpd_file", "dpd_in_update_message", 10, 1 );
function dpd_in_update_message($create_function)
	{
		$license_message = '<br>You require a license key to be able to further use the plugin and get updates to the plugin. <a href="https://www.emoose.de/produkt/woocommerce-dpd-versandetikett-generator/">Click to purchase a license!!!</a>';
		if(!get_option('dpdl'))	echo $license_message;	
	}

//require_once __DIR__ . '/mpdf/vendor/autoload.php';

global $wpdb;

register_activation_hook(__FILE__, 'dpd_register_activation');

function dpd_register_activation($network_wide)
	{
		global $wpdb;
		if (is_multisite() and $network_wide) {
			$blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
			foreach ($blogids as $blog_id) {
				switch_to_blog($blog_id);
				dpd_create_tables();
				restore_current_blog();
			}
		}
		else
		{
			dpd_create_tables();
		}
}
/* tracking disable code */
function dpda_disable_woocommerce_tracking_infos() {
    // Check if WooCommerce is active and custom option is enabled
    if (class_exists('WooCommerce') && ice_get_option('dpd_disable_order_tracking', 'dpd_options') == 'ON') {
        // Remove the order tracking shortcode
        remove_shortcode('woocommerce_order_tracking');
		error_log('Order tracking shortcode disabled.');
        // Remove the "Order Tracking" endpoint in My Account
        add_filter('woocommerce_account_menu_items', function($endpoints) {
            unset($endpoints['order-tracking']);
            return $endpoints;
        });
		// Hide order tracking form using CSS
        add_action('wp_head', function() {
            echo '<style>
                .woocommerce-form-track-order.track_order {
                    display: none !important;
                }
            </style>';
        });
		// Remove tracking information from emails
        add_filter('woocommerce_email_order_meta_fields', function($fields, $sent_to_admin, $order) {
            // Remove specific meta fields related to order tracking
            unset($fields['order_tracking']); // Adjust the key as per your tracking meta field
            return $fields;
        }, 10, 3);
        add_filter('woocommerce_email_order_details', function($output, $order, $sent_to_admin) {
            // Remove or modify tracking information in the email details
            $output = preg_replace('/Order Tracking Info: .*?(\n|$)/', '', $output); // Adjust regex for your tracking text
            return $output;
        }, 10, 3);
        error_log('Order tracking info disabled in emails.');
    } 
}
add_action('init', 'dpda_disable_woocommerce_tracking_infos');
/* code end here */
function dpd_create_tables(){
	global $wpdb;
$charset_collSate = $wpdb->get_charset_collate();
$table_name = $wpdb->prefix . 'dpd_orders';
$sql1 = "CREATE TABLE IF NOT EXISTS $table_name (
	id int(11) NOT NULL AUTO_INCREMENT,
	order_id int(11) NOT NULL,
  	weight DOUBLE NULL,
	parcel_number varchar(25) NULL,
	delivery_service varchar(100) NULL,
	pdf_data longtext NULL,
	page_size varchar(10) NULL,
	shipping_method varchar(50) NULL,
	reference_1 varchar(50) NULL,
	reference_2 varchar(50) NULL,
	predict_function varchar(4) NULL,
	date longtext NULL,
	shipping_date bigint NULL,
  	original_data LONGTEXT NULL,
	original_data_type VARCHAR(20) NULL,
	order_type VARCHAR(30) NULL,
  	custom_data LONGTEXT NULL,
  	raw_data LONGTEXT NULL,
  	status VARCHAR(20) NULL DEFAULT 'publish',
	order_tracking varchar(2) NOT NULL DEFAULT 1,
    PRIMARY KEY (id)
) $charset_collSate;";
	
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

dbDelta( $sql1 );

//$wpdb->query("ALTER TABLE $table_name MODIFY COLUMN page_size VARCHAR(10) NULL");
}

function dpd_on_create_blog( $blog_id, $user_id, $domain, $path, $site_id, $meta ) {
	if (is_multisite()) {
		if ( is_plugin_active_for_network( 'plugin-name/plugin-name.php' ) ) {
			switch_to_blog( $blog_id );
			dpd_create_tables();
			restore_current_blog();
		}
	}
}
add_action( 'wpmu_new_blog', 'dpd_on_create_blog', 10, 6 );


if(isset($_POST['ice_save_settings'])){
	$new_values = array(
		'dpd_client_user_id' => isset( $_POST['dpd_client_user_id'] ) ? $_POST['dpd_client_user_id'] : '',
		'dpd_client_token' => isset( $_POST['dpd_client_token'] ) ? $_POST['dpd_client_token'] : '',
		'dpd_sender_name' => isset( $_POST['dpd_sender_name'] ) ? $_POST['dpd_sender_name'] : '',
		'dpd_sender_street' => isset( $_POST['dpd_sender_street'] ) ? $_POST['dpd_sender_street'] : '',
		'dpd_sender_country' => isset( $_POST['dpd_sender_country'] ) ? $_POST['dpd_sender_country'] : '',
		'dpd_sender_zipcode' => isset( $_POST['dpd_sender_zipcode'] ) ? $_POST['dpd_sender_zipcode'] : '',
		'dpd_sender_city' => isset( $_POST['dpd_sender_city'] ) ? $_POST['dpd_sender_city'] : '',
		'dpd_packaging_weight' => isset( $_POST['dpd_packaging_weight'] ) ? $_POST['dpd_packaging_weight'] : '',
		'pdf_page_size' => isset( $_POST['pdf_page_size'] ) ? $_POST['pdf_page_size'] : '',
		'dpd_label_position' => isset( $_POST['dpd_label_position'] ) ? $_POST['dpd_label_position'] : '',
		'dpd_salutation' => isset( $_POST['dpd_salutation'] ) ? $_POST['dpd_salutation'] : '',
		'dpd_content' => isset( $_POST['dpd_content'] ) ? $_POST['dpd_content'] : '',
		'dpd_multiple_shipping_labels' => isset( $_POST['dpd_multiple_shipping_labels'] ) ? $_POST['dpd_multiple_shipping_labels'] : '',
		
		'dpd_cl' => isset( $_POST['dpd_cl'] ) ? $_POST['dpd_cl'] : '',
		'dpd_cl_cod' => isset( $_POST['dpd_cl_cod'] ) ? $_POST['dpd_cl_cod'] : '',
		'dpd_shop_delivery' => isset( $_POST['dpd_shop_delivery'] ) ? $_POST['dpd_shop_delivery'] : '',
		'dpd_e18' => isset( $_POST['dpd_e18'] ) ? $_POST['dpd_e18'] : '',
		'dpd_e18_cod' => isset( $_POST['dpd_e18_cod'] ) ? $_POST['dpd_e18_cod'] : '',
		'dpd_e830' => isset( $_POST['dpd_e830'] ) ? $_POST['dpd_e830'] : '',
		'dpd_e830_cod' => isset( $_POST['dpd_e830_cod'] ) ? $_POST['dpd_e830_cod'] : '',
		'dpd_e10' => isset( $_POST['dpd_e10'] ) ? $_POST['dpd_e10'] : '',
		'dpd_e10_cod' => isset( $_POST['dpd_e10_cod'] ) ? $_POST['dpd_e10_cod'] : '',
		'dpd_e12' => isset( $_POST['dpd_e12'] ) ? $_POST['dpd_e12'] : '',
		'dpd_e12_cod' => isset( $_POST['dpd_e12_cod'] ) ? $_POST['dpd_e12_cod'] : '',
		'dpd_e12_saturday' => isset( $_POST['dpd_e12_saturday'] ) ? $_POST['dpd_e12_saturday'] : '',
		'dpd_express_international' => isset( $_POST['dpd_express_international'] ) ? $_POST['dpd_express_international'] : '',
		'dpd_shop_return' => isset( $_POST['dpd_shop_return'] ) ? $_POST['dpd_shop_return'] : '',
		'dpd_cl_return' => isset( $_POST['dpd_cl_return'] ) ? $_POST['dpd_cl_return'] : '',
		
		'dpd_reference_1' => isset( $_POST['dpd_reference_1'] ) ? $_POST['dpd_reference_1'] : '',
		'dpd_reference_2' => isset( $_POST['dpd_reference_2'] ) ? $_POST['dpd_reference_2'] : '',
		'dpd_predict_function_default' => isset( $_POST['dpd_predict_function_default'] ) ? $_POST['dpd_predict_function_default'] : '',
		'dpd_calculate_weight' => isset( $_POST['dpd_calculate_weight'] ) ? $_POST['dpd_calculate_weight'] : '',
		'dpd_default_weight' => isset( $_POST['dpd_default_weight'] ) ? $_POST['dpd_default_weight'] : '',
		'dpd_debug' => ( isset( $_POST['dpd_debug'] ) && $_POST['dpd_debug'] == 1 ) == true ? 1 : 0,
		'dpd_auto_completed' => ( isset( $_POST['dpd_auto_completed'] ) && $_POST['dpd_auto_completed'] == 1 ) == true ? 1 : 0,
		'dpd_must_house_number' => ( isset( $_POST['dpd_must_house_number'] ) && $_POST['dpd_must_house_number'] == 1 ) == true ? 1 : 0,
		//'dpd_disable_order_completion' => ( isset( $_POST['dpd_disable_order_completion'] ) && $_POST['dpd_disable_order_completion'] == 1 ) == true ? 1 : 0,
		'dpd_disable_order_tracking' => ( isset( $_POST['dpd_disable_order_tracking'] ) && $_POST['dpd_disable_order_tracking'] == 'ON' ) == true ? 'ON' : 'OFF',
		'dpd_auto_generate_shipping_label_oc' => ( isset( $_POST['dpd_auto_generate_shipping_label_oc'] ) && $_POST['dpd_auto_generate_shipping_label_oc'] == 1 ) == true ? 1 : 0,
		'dpd_auto_generate_shipping_label_op' => ( isset( $_POST['dpd_auto_generate_shipping_label_op'] ) && $_POST['dpd_auto_generate_shipping_label_op'] == 1 ) == true ? 1 : 0,
		'dpd_auto_monday' => ( isset( $_POST['dpd_auto_monday'] ) && $_POST['dpd_auto_monday'] == 1 ) == true ? 1 : 0,
		'dpd_label_phone_no' => ( isset( $_POST['dpd_label_phone_no'] ) && $_POST['dpd_label_phone_no'] == 1 ) == true ? 1 : 0,
		'dpd_label_higher_insurance' => ( isset( $_POST['dpd_label_higher_insurance'] ) && $_POST['dpd_label_higher_insurance'] == 1 ) ? 1 : 0,
        //'dpd_label_higher_insurance_amount' => isset( $_POST['dpd_label_higher_insurance_amount'] ) ? sanitize_text_field( $_POST['dpd_label_higher_insurance_amount'] ) : '',
       // 'dpd_label_higher_insurance_currency' => isset( $_POST['dpd_label_higher_insurance_currency'] ) ? sanitize_text_field( $_POST['dpd_label_higher_insurance_currency'] ) : '',
	);
	
	update_option('dpd_options',$new_values);
}
elseif(isset($_POST['activate_dpd']))
	{
		$dpdl = '';	
		if(isset($_POST['dpdl']) and $_POST['dpdl'])
			{	
				$dpdl = esc_sql($_POST['dpdl']);
				$api_params = array(
					'a' => 'activate',
					'l' => $dpdl,
					'i' => REF,
					'd' => $_SERVER['SERVER_NAME'],
				);
				$query = esc_url_raw(add_query_arg($api_params, LURL));				
				
				$response = wp_remote_get($query, array('timeout' => 20, 'sslverify' => false));
				if (is_wp_error($response)){
					$msg = "Unexpected Error! Activation could not be processed.";
					new DPD_notify( $msg, "notice notice-error" );
				}
				$license_data = json_decode(wp_remote_retrieve_body($response));
				if(isset($license_data->result) and $license_data->result == 'success'){            
					update_option('dpdl', $dpdl);
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;
					new DPD_notify( $msg, "notice notice-success" ); 
				}
				else{
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;	
					new DPD_notify( $msg, "notice notice-error" );
				}
			}
	}
elseif(isset($_POST['deactivate_dpd']))
	{
		$dpdl = '';		
		if(isset($_POST['dpdl']) and $_POST['dpdl'])
			{	
				$dpdl = esc_sql($_POST['dpdl']);
				$api_params = array(
					'a' => 'deactivate',
					'l' => $dpdl,
					'i' => REF,
					'd' => $_SERVER['SERVER_NAME'],
				);
				$query = esc_url_raw(add_query_arg($api_params, LURL));
				$response = wp_remote_get($query, array('timeout' => 20, 'sslverify' => false));
		
				if (is_wp_error($response)){
					$msg = "Unexpected Error! Deactivation could not be processed.";
					new DPD_notify( $msg, "notice notice-error" );
				}
				$license_data = json_decode(wp_remote_retrieve_body($response));
				if(isset($license_data->result) and $license_data->result == 'success'){            
					update_option('dpdl', '');
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;
					new DPD_notify( $msg, "notice notice-success" );
				}
				else{
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;
					new DPD_notify( $msg, "notice notice-error" );
				}
			}
	}
elseif(isset($_POST['activate_dpdon']))
	{
		$dpdl = '';		
		if(isset($_POST['dpdon']) and $_POST['dpdon'] and is_numeric($_POST['dpdon']))
			{	
				$dpdon = esc_sql($_POST['dpdon']);
				$api_params = array(
					'a' => 'gactivate',
					'l' => $dpdon,
					'i' => REF,
					'd' => $_SERVER['SERVER_NAME'],
				);
				$query = esc_url_raw(add_query_arg($api_params, LURL));
				$response = wp_remote_get($query, array('timeout' => 20, 'sslverify' => false));
		
				if (is_wp_error($response)){
					$msg = "Unexpected Error! Deactivation could not be processed.";
					new DPD_notify( $msg, "notice notice-error" );
				}
				
				$license_data = json_decode(wp_remote_retrieve_body($response));
				
				if(isset($license_data->result) and $license_data->result == 'success'){ 
					$dpdl = esc_sql($license_data->key);
					update_option('dpdl', $dpdl);
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;
					new DPD_notify( $msg, "notice notice-success" );
				}
				else{
					$msg = "Unexpected Error!";	if(isset($license_data->message))	$msg = $license_data->message;
					new DPD_notify( $msg, "notice notice-error" );
				}
			}
	}

add_action('admin_enqueue_scripts', 'dpd_enqueue_scripts');
function dpd_enqueue_scripts() {
	$screen = get_current_screen();
	if( $screen->id == 'woocommerce_page_wc-orders' || $screen->id == 'shop_order' ){
		wp_enqueue_style('pickmeup-style', plugin_dir_url( __FILE__ ).'css/pickmeup.css');	
		wp_enqueue_script('pickmeup-script', plugin_dir_url( __FILE__ ).'js/jquery.pickmeup.min.js');		
	}
	
	if( isset($_GET['page']) && $_GET['page'] == 'dpd_settings'){
		$dv = time();
		wp_enqueue_script('jqueryuicore', 'https://code.jquery.com/ui/1.12.1/jquery-ui.js', array('jquery'), $dv);
		wp_enqueue_script('dpdsl', plugins_url( 'js/jquery.dpdsl.js', __FILE__ ), array('jquery'));
		wp_enqueue_style('jqueryuicss', '//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css');
	}
}

add_action('admin_head', 'dpd_datepicker'); 
function dpd_datepicker() { 
	$screen = get_current_screen();
	if( $screen->id == 'woocommerce_page_wc-orders' || $screen->id == 'shop_order'){
	?>

	<script>
	jQuery(document).ready(function(){
		var eleShipDate = document.getElementsByClassName("ship_date_cls_de");
		if(eleShipDate)
			{
				/*jQuery('#ship-date').pickmeup({
					format  : 'Y-m-d'
				});*/
				pickmeup('.ship_date_cls_de', {
					format	: 'Y-m-d',
					hide_on_select : true,
					default_date : false
				});
			}
			
		var eleTabs = document.getElementById("tabs");
		if(eleTabs)
			{
				var tabs = jQuery( "#tabs" ).tabs();
			}
	});
  </script>
<?php
	} 
}

/*add_action('admin_menu','add_dpd_page');
function add_dpd_page(){
	add_options_page('DPD Settings', 'DPD Settings', 'manage_options', 'dpd_settings', 'dpd_settings');
}*/

add_action('admin_menu', 'add_dpd_page');
function add_dpd_page(){
    add_submenu_page('woocommerce','DPD Settings','DPD Settings','manage_options','dpd_settings','dpd_settings');
}


function ice_get_option( $name, $option ) {
	$get_options = get_option($option);
	
	if( !empty( $get_options[$name] ))
		return $get_options[$name];
		
	return false ;
}

/*******************************************************************************/
/*******************************************************************************/
/***********************  To show panel fields *********************************/
/*******************************************************************************/
/*******************************************************************************/

function ice_options($value, $option) {
	if(!isset($value['id']))	$value['id'] = '';
	if(!isset($value['name']))	$value['name'] = '';
	if(!isset($value['unique-num']))	$value['unique-num'] = '';
	if(!isset($value['object-type']))	$value['object-type'] = '';
	if(!isset($value['rows']))	$value['rows'] = '';
	if(!isset($value['cols']))	$value['cols'] = '';
	if(!isset($value['description']))	$value['description'] = '';

	switch($value['type']) { 
		case 'text' : echo '<label for="'.$value['id'].'">'.$value['name'].'</label><br>'; ?>		
		<input type="text" name="<?php echo $value['id']; ?>" value="<?php echo ice_get_option($value['id'], $option); ?>" id="<?php echo $value['id']; ?>" />
		<?php break;

		case 'email' : echo '<label for="'.$value['id'].'">'.$value['name'].'</label><br>'; ?>		
		<input type="email" name="<?php echo $value['id']; ?>" value="<?php echo ice_get_option($value['id'], $option); ?>" id="<?php echo $value['id']; ?>" />
		<?php break;

		case 'number' : echo '<label for="'.$value['id'].'">'.$value['name'].'</label><br>'; ?>		
		<input type="number" name="<?php echo $value['id']; ?>" value="<?php echo ice_get_option($value['id'], $option); ?>" id="<?php echo $value['id']; ?>" />
		<?php break;

		case 'datetime-local' : echo $value['name'] . ' ';		
		$start_date = date("Y-m-d H:i",intval(ice_get_option($value['id'], $option)));
		$date_array = explode(" ",$start_date);
		$date = $date_array[0];
		$time = $date_array[1];
		$com_date = $date.'T'.$time;	?>		
		<input type="datetime-local" name="<?php echo $value['id']; ?>" value="<?php echo esc_attr($com_date); ?>" id="<?php echo $value['id']; ?>" />		
		<?php break;

		case 'date' : echo $value['name'] . ' ';
		$start_date = date("Y-m-d",intval(ice_get_option($value['id'], $option)));
		$date_array = explode("-",$start_date);
		$year = $date_array[0];
		$month = $date_array[1];
		$date = $date_array[2];
		?>		
		<input type="date" name="<?php echo $value['id']; ?>" value="<?php echo esc_attr($start_date); ?>" id="<?php echo $value['id']; ?>" />
		<?php break;

		case 'upload' : echo $value['name'] . ' ';?>
		<input type="text" name="<?php echo $value['id']; ?>" value="<?php echo ice_get_option($value['id'], $option); ?>" id="field_<?php echo $value['unique-num']; ?>" />
		<input type="button" name="<?php echo $value['id']; ?>" value="Upload" id="<?php echo $value['unique-num']; ?>" class="button upload-single-object-<?php echo $value['object-type']; ?>" /> <?php
		break;

		case 'textarea' : echo $value['name'] . '<br>'; ?>
		<textarea name="<?php echo $value['id']; ?>" rows="<?php echo $value['rows']; ?>" cols="<?php echo $value['cols']; ?>" id="<?php echo $value['id']; ?>"><?php echo ice_get_option($value['id'], $option); ?></textarea><?php
		break;

		case 'radio' : echo $value['name'] . ' ' . $value['description'] . '<br><br>';
			foreach($value['options'] as $key => $optio) { ?>
		<input type="radio" id="<?php echo $key; ?>" name="<?php echo $value['id']; ?>" value="<?php echo $key; ?>" <?php if(ice_get_option($value['id'], $option) == $key) { echo 'checked="checked"'; }?> ><?php echo $optio; 
			}
		break;

		case 'select' : echo $value['name'] . '<br><br>';
			?>
            <select id="<?php echo $key; ?>" name="<?php echo $value['id']; ?>">
			<?php
			foreach($value['options'] as $key => $optio) { $selected = ''; if(ice_get_option($value['id'], $option) == $key) $selected = ' selected="selected"'; ?> 
            	<option value="<?php echo $key; ?>"<?php echo $selected; ?>><?php echo $optio; ?></option> 
            <?php
			}
			?>
            </select>
            <br /><br /><?php echo $value['description']; ?>
            <?php
		break;

		case 'checkbox': ?>
		<input type="checkbox" id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>" value="1" <?php echo ice_get_option( $value['id'], $option ) == 1 ? 'checked="checked"' : ''; ?> />
		<label for="<?php echo $value['id']; ?>"><?php echo $value['name'] . ' ' . $value['description']; ?></label> <?php
	}
}


add_action('admin_head', 'delete_labels_code');
function delete_labels_code(){
	?>
	<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery('body').on('click', '#delete-shipping-labels-button', function(){
				var before_date = jQuery('#delete-shipping-date').val();
				if( before_date != "" && before_date !== undefined ){
					var z = confirm("Are you Sure you want to delete the labels before "+before_date);
					if( z == true ){
						var ajax_data = {
							action: 'delete_shipping_labels_before_date',
							date: before_date
						};
						jQuery.post(ajaxurl, ajax_data, function(res){
							if( res == "1" ){
								alert("Shipping labels before "+before_date+" has been deleted.");
							}
							else{
								alert("Failed to delete shipping labels."+ res);
							}
						});
					}
				}
			});
		});
	</script>
	<?php
}

add_action('wp_ajax_delete_shipping_labels_before_date', 'delete_shipping_labels_before_date');
function delete_shipping_labels_before_date(){
	if( isset($_POST['date']) ){
		global $wpdb;
		$date = strtotime($_POST['date']);
		$table = $wpdb->prefix.'dpd_orders';
		
		$delete = $wpdb->query("DELETE FROM $table WHERE shipping_date <= $date");

		echo "1";
		
	}
	die;
}

function dpd_settings(){
	
	echo '<div class="dpd_container">';
	
	echo '<div id="tabs"><ul>
		<li><a href="#tab_dpd_settings">'.__( "DPD Settings", "dpd-shipping-label" ).'</a></li>
		<li><a href="#tab_dpd_license">'.__( 'DPD License Management', 'dpd-shipping-label' ).'</a></li>
		<li><a href="#tab_dpd_tracking">'.__( 'DPD Tracking Numbers', 'dpd-shipping-label' ).'</a></li>
	</ul>';
	
	
	echo '<div id="tab_dpd_settings">';

	echo '<h2>'.__( "DPD Actions", "dpd-shipping-label" ).'</h2>';
	echo '<div class="download-shipping-labels-container">
			<form action="'.get_site_url().'" method="get" target="_blank">
			'.__( 'Download Shipping Labels (shipping date)', 'dpd-shipping-label' ).'<br>
			'.__( "From", "dpd-shipping-label" ).'<br><input type="text" id="download-from-shipping-date" name="download_from_shipping_date" autocomplete="off" /><br><br>
			'.__( "To", "dpd-shipping-label" ).'<br><input type="text" id="download-to-shipping-date" name="download_to_shipping_date" autocomplete="off" /><Br><Br>
			<input type="submit" name="download_shipping_list" value="'.__( 'Download Shipping List', 'dpd-shipping-label' ).'" id="download-shipping-labels-button-list" class="button button-primary" style="cursor:pointer;" />
			<input type="submit" name="download_shipping_labels" value="'.__( 'Download Shipping Labels', 'dpd-shipping-label' ).'" id="download-shipping-labels-button-labels" class="button button-primary" style="cursor:pointer;" />
			</form>
		</div>
	';	
	
	echo '<br>Delete Shipping Labels before date (shipping date)<br>';
	echo '<input type="text" id="delete-shipping-date" />&nbsp;&nbsp;<span id="delete-shipping-labels-button" class="button" style="cursor:pointer;">'.__( "Trash", "dpd-shipping-label" ).'</span>';	

	// Code start here email field 
	echo "<div class='dpd-form-email' style='padding:20px 0px;'>
    <form method='post'>
		<label for='email_label_input'><strong>Enter User Email Here:</strong></label><br>
		<input type='email' name='email_label' id='email_label_dpd'>
		<input type='submit' class='button-primary' name='dpd_emailaddress' value='Insert Email'>
	</form>";
if (isset($_POST['dpd_emailaddress'])) {
    global $wpdb;

    $email_address = sanitize_email($_POST['email_label']);
    #echo $email_address;

    $wc_table_name = $wpdb->prefix . 'wc_orders';
    $dpd_table_name = $wpdb->prefix . 'dpd_orders';

    // Prepare and execute the SQL query with a JOIN operation
    $sql = $wpdb->prepare("
        SELECT wc.*, dpd.*
        FROM $wc_table_name AS wc
        JOIN $dpd_table_name AS dpd ON wc.id = dpd.order_id
        WHERE wc.billing_email = %s
    ", $email_address);

    echo 'SQL Query: ' . $sql . '<br>'; // Print the SQL query for debugging

    $results = $wpdb->get_results($sql);
	echo'<pre>';
	print_r($results);
	echo'</pre>';
    if ($wpdb->last_error) {
        echo 'Database Error: ' . $wpdb->last_error;
    } else {
        if (!empty($results)) {
            // Prepare the email content
            $email_subject = 'Order Details';
            $email_message = 'Here are the details of your orders:' . PHP_EOL;

foreach ($results as $result) {
    $email_message .= 'Order ID: ' . esc_html($result->order_id) . PHP_EOL;

    // Assuming the PDF file data is stored in a column called 'pdf_data'
    $pdf_data = $result->pdf_data;

    // Debugging: Print PDF file data
    echo 'PDF File Data: ' . $pdf_data . '<br>';

    // Decode base64-encoded PDF data
    $pdf_content = base64_decode($pdf_data);

    if ($pdf_content !== false) {
        // Save the PDF content to a temporary file
        $temp_pdf_file = tempnam(sys_get_temp_dir(), 'pdf');
        file_put_contents($temp_pdf_file, $pdf_content);

        // Attach the temporary PDF file to the email
        $attachments = array($temp_pdf_file);

        // Send the email with attachment
        $email_sent = wp_mail($email_address, $email_subject, $email_message, '', $attachments);

        if ($email_sent) {
            echo 'Email sent successfully!';
        } else {
            echo 'Failed to send email. Please check your email configuration.';
        }

        // Clean up: Remove the attached temporary PDF file after sending the email
        unlink($temp_pdf_file);
    } else {
        echo 'Failed to decode PDF file data.';
    }
}
        } else {
            echo 'No results found for the given email address.';
        }
    }
}
	// code close here of email 

	echo '<br><br>';
	echo '<h2>'.__( "DPD Settings", "dpd-shipping-label" ).'</h2>';
			
	echo '<script type="text/javascript">
			jQuery(document).ready(function(){
				jQuery("#delete-shipping-date, #download-from-shipping-date, #download-to-shipping-date").datepicker({dateFormat: "yy-mm-dd"});});
		</script>';
	echo '<form action="#" method="post">';
	/* echo '<br>';

	//__( , 'dpd-shipping-label' )
	echo '<br />'; */
	echo '<h4>'.__( 'Client Credentials', 'dpd-shipping-label' ).'</h4>';
	echo '<hr>';
	echo '<br>';
	ice_options(array(
		'name' => __( 'Client User ID', 'dpd-shipping-label' ),
		'id'   => 'dpd_client_user_id',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Client Token', 'dpd-shipping-label' ),
		'id'   => 'dpd_client_token',
		'type' => 'text'
	)
	,'dpd_options');
	
	
	echo '<br><br>';
	echo '<h4>'.__( 'DPD Parcel Settings', 'dpd-shipping-label' ).'</h4>';
	echo '<hr>';
	echo '<br>';
	
	ice_options(array(
		'name' => __( 'PDF Page Size', 'dpd-shipping-label' ),
		'id'   => 'pdf_page_size',
		'type' => 'radio',
		'options' => array(
						'A4' => 'DIN A4',
						'A6' => 'DIN A6'
					),
		'description' => __( '( Only new orders will be affected by this option )', 'dpd-shipping-label' )
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Label Start Position', 'dpd-shipping-label' ),
		'id'   => 'dpd_label_position',
		'type' => 'radio',
		'options' => array(
						'UpperLeft' => __( 'Upper Left', 'dpd-shipping-label' ),
						'UpperRight' => __( 'Upper Right', 'dpd-shipping-label' ),
						'LowerLeft' => __( 'Lower Left', 'dpd-shipping-label' ),
						'LowerRight' => __( 'Lower Right', 'dpd-shipping-label' ),
					),
		'description' => __( '( Only new orders will be affected by this option )', 'dpd-shipping-label' )
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Default Salutation', 'dpd-shipping-label' ),
		'id'   => 'dpd_salutation',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Parcel Content Description (max. 35 characters)', 'dpd-shipping-label' ),
		'id'   => 'dpd_content',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';

	
	ice_options(array(
		'name' => __( 'Referenz 1', 'dpd-shipping-label' ),
		'id'   => 'dpd_reference_1',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Referenz 2', 'dpd-shipping-label' ),
		'id'   => 'dpd_reference_2',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Default value for Predict Function', 'dpd-shipping-label' ),
		'id'   => 'dpd_predict_function_default',
		'type' => 'radio',
		'options' => array(
			'ON' => __( 'ON', 'dpd-shipping-label' ),
			'OFF' => __( 'OFF', 'dpd-shipping-label' )
		),
		'description' => ''
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Calculate weight from', 'dpd-shipping-label' ),
		'id'   => 'dpd_calculate_weight',
		'type' => 'radio',
		'options' => array(
			'product' => __( 'products', 'dpd-shipping-label' ),
			'default' => __( 'fixed weight for all orders', 'dpd-shipping-label' )
		),
		'description' => ''
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Enter Default weight in Kg for all orders ( This option only matters when the above option is selected as "fixed weight for all orders" )', 'dpd-shipping-label' ),
		'id'   => 'dpd_default_weight',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Classic  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_cl',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Classic COD  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_cl_cod',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Shop Delivery  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_shop_delivery',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Shop Return  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_shop_return',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Classic Return  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_cl_return',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E18  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e18',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E18 COD  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e18_cod',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E830  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e830',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E830 COD  ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e830_cod',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E10   ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e10',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E10 COD ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e10_cod',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E12 ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e12',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E12 COD ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e12_cod',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';

	ice_options(array(
		'name' => __( 'Shipping Methods for DPD E12 COD ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_e12_saturday',
		'type' => 'text'
	)
	,'dpd_options');
	
	
	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Shipping Methods for DPD Express International ( Separate methods by comma )', 'dpd-shipping-label' ),
		'id'   => 'dpd_express_international',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	echo '<br><br>';
	echo '<h4>'.__( 'Sender Details', 'dpd-shipping-label' ).'</h4>';
	echo '<hr>';
	echo '<br>';
	
	ice_options(array( 
		'name' => __( 'Sender Name', 'dpd-shipping-label' ),
		'id'   => 'dpd_sender_name',
		'type' => 'text'
	)
	,'dpd_options');
	echo '<br><br>';
	ice_options(array(
		'name' => __( 'Street', 'dpd-shipping-label' ),
		'id'   => 'dpd_sender_street',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	ice_options(array(
		'name' => __( 'Country', 'dpd-shipping-label' ),
		'id'   => 'dpd_sender_country',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	ice_options(array(
		'name' => __( 'ZipCode', 'dpd-shipping-label' ),
		'id'   => 'dpd_sender_zipcode',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';
	ice_options(array(
		'name' => __( 'City', 'dpd-shipping-label' ),
		'id'   => 'dpd_sender_city',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';

	echo '<h4>'.__( 'Order Settings', 'dpd-shipping-label' ).'</h4>';
	echo '<hr>';
	
	ice_options(array(
		'name' => __( 'Multiple Shipping Labels', 'dpd-shipping-label' ),
		'id'   => 'dpd_multiple_shipping_labels',
		'type' => 'select',
		'options' => array(
						'automatic' => __( 'Automatically create multiple labels for 31.5 Kg. weight limit', 'dpd-shipping-label' ),
						'manual' => __( 'Manually define weight for each label (while creating label on order details page)', 'dpd-shipping-label' ),
					),
		'description' => __( 'There is a limit of 31.5 Kg. maximum weight per label.<br>This option works only when creating single label on order details page. In case of bulk generation of labels, this option does not work and automatic method is used', 'dpd-shipping-label' )
	)
	,'dpd_options');
	
	echo '<br><br>';
	ice_options(array(
		'name' => __( 'Packaging Weight (GRAMS)', 'dpd-shipping-label' ),
		'id'   => 'dpd_packaging_weight',
		'type' => 'text'
	)
	,'dpd_options');
	
	echo '<br><br>';

	ice_options(array(
		'name' => __( 'Automatically set order to "completed" when DPD label is created?', 'dpd-shipping-label' ),
		'id'   => 'dpd_auto_completed',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'User must enter House Number in the shipping address?', 'dpd-shipping-label' ),
		'id'   => 'dpd_must_house_number',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	/* ice_options(array(
		'name' => __( 'Disable Order Completion (When creating shipping labels)', 'dpd-shipping-label' ),
		'id'   => 'dpd_disable_order_completion',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>'; */
	
	ice_options(array(
		'name' => __( 'Auto generate the Shipping label, when the order status is changed to Completed', 'dpd-shipping-label' ),
		'id'   => 'dpd_auto_generate_shipping_label_oc',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>';

	ice_options(array(
		'name' => __( 'Auto generate the Shipping label, when the order status is changed to Processing', 'dpd-shipping-label' ),
		'id'   => 'dpd_auto_generate_shipping_label_op',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>';

	ice_options(array(
		'name' => __( 'Automatically choose date on Monday, for bulk generation of labels, if weekend', 'dpd-shipping-label' ),
		'id'   => 'dpd_auto_monday',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>';

	ice_options(array(
		'name' => __( 'Add and display order billing phone number in the label PDF', 'dpd-shipping-label' ),
		'id'   => 'dpd_label_phone_no',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');

	echo '<br><br>';
	
	ice_options(array(
		'name' => __( 'Automatically apply higher insurance if the total order amount exceeds €520', 'dpd-shipping-label' ),
		'id'   => 'dpd_label_higher_insurance',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');
	
	echo '<br><br>';
	
	/*ice_options( array(
    'name' => __( 'Higher Insurance Amount (e.g., 10000 for €100.00)', 'dpd-shipping-label' ),
    'id' => 'dpd_label_higher_insurance_amount',
    'type' => 'text',
), 'dpd_options' );
	
	echo '<br><br>'; */
	
	/*ice_options( array(
    'name' => __( 'Currency (e.g., EUR)', 'dpd-shipping-label' ),
    'id' => 'dpd_label_higher_insurance_currency',
    'type' => 'text',
), 'dpd_options' );
	
	echo '<br><br>';*/
	
	// Enable / Disable default order tracking 
	ice_options(array(
		'name'        => __( 'Enable / Disable Default Order Tracking', 'dpd-shipping-label' ),
		'id'          => 'dpd_disable_order_tracking',
		'type'        => 'radio',
		'options'     => array(
			'ON'  => __( 'ON', 'dpd-shipping-label' ),
			'OFF' => __( 'OFF', 'dpd-shipping-label' )
		),
		'description' => '',
		'default'     => get_option('dpd_disable_order_tracking', 'ON') == 'OFF' ? 'ON' : 'OFF'
	), 'dpd_options');
	
	echo '<br><br>';
	
	echo '<h4>'.__( 'Debug Details', 'dpd-shipping-label' ).'</h4>';
	echo '<hr>';

	echo '<br><br>';
	ice_options(array(
		'name' => __( 'Debug', 'dpd-shipping-label' ),
		'id'   => 'dpd_debug',
		'type' => 'checkbox',
		'description' => ''
	)
	,'dpd_options');
	
	submit_button('Update','primary','ice_save_settings');
	echo '</form>';

	echo '<hr>';
	echo '<a href="https://www.emoose.de/problemmeldung-dpd-plugin/" target="_blank">'.__( 'Fehler melden', 'dpd-shipping-label' ).'</a>';
	
		
	echo '</div>';	//End content for Tab DPD Settings
	echo'</div>';
	$dpdl = get_option('dpdl');
	
	echo '<div id="tab_dpd_license">
		<form action="" method="post">
			<p>
				<input type="radio" name="method_activation" id="ulk" value="mlk" checked="checked"><label for="ulk">'.__( 'I have a License Key', 'dpd-shipping-label' ).'</label><br>
				<input type="radio" name="method_activation" id="uon" value="mon"><label for="uon">'.__( 'I have an Order Number', 'dpd-shipping-label' ).'</label>
			</p>
			<div id="optslk">
				<p>'.__( 'Please enter the license key for this product to activate it. You were given a license key when you purchased this item.', 'dpd-shipping-label' ).'</p>
				<table class="form-table">
					<tr>
						<th style="width:100px;"><label for="dpdl">License Key</label></th>
						<td ><input class="regular-text" type="text" id="dpdl" name="dpdl"  value="'.$dpdl.'" ></td>
					</tr>
				</table>
				<p class="submit">
					<input type="submit" name="activate_dpd" value="'.__( 'Activate', 'dpd-shipping-label' ).'" class="button-primary" />
					<input type="submit" name="deactivate_dpd" value="'.__( 'Deactivate', 'dpd-shipping-label' ).'" class="button" />
				</p>
			</div>
			<div id="optson">
				<p>'.__( 'Please enter your order number. You received that in your order confirmation email, after your purchase', 'dpd-shipping-label' ).'</p>
				<table class="form-table">
					<tr>
						<th style="width:100px;"><label for="dpdl">'.__( 'Order Number', 'dpd-shipping-label' ).'</label></th>
						<td ><input class="regular-text" type="text" id="dpdon" name="dpdon"  value="" ></td>
					</tr>
				</table>
				<p class="submit">
					<input type="submit" name="activate_dpdon" value="'.__( 'Activate', 'dpd-shipping-label' ).'" class="button-primary" />
				</p>
			</div>
		</form>
	</div>';	//End Tab for DPD License
	
/* code add here  tracking numbers for an order */	
// Check if an order ID is submitted
echo "<div id='tab_dpd_tracking'>";	
echo "<h4 style='padding:0px 15px;margin:10px 0px;'>GET Order Tracking Number Here</h4>";
	echo"<p style='padding:8px 15px;width:800px;margin: 0px'>Welcome to our efficient order tracking system! Simply enter your order details below, and instantly retrieve your unique tracking number. Stay informed about the status and location of your package as it makes its way to you.</p>";
   if (isset($_POST['order_id_input'])) {
    $order_id = intval($_POST['order_id_input']);

    global $wpdb;

    $table_name = $wpdb->prefix . 'dpd_orders';
    // Prepare and execute the SQL query
    $sql = $wpdb->prepare("SELECT * FROM $table_name WHERE order_id = %d", $order_id);
    $results = $wpdb->get_results($sql);

    #echo '<pre>';
    #print_r($results);
    #echo '</pre>';
	#die();
    // Output the result
    if (!empty($results)) {
        // Assuming parcel_number is the column in your table
        $parcel_numbers = wp_list_pluck($results, 'parcel_number');
        echo "<strong style='padding: 1em 1.4em;'>Order ID:</strong> " . $order_id . ', <strong>Tracking Numbers:</strong> ' . implode(', ', $parcel_numbers);
    } else {
        echo 'No tracking numbers found for the specified order ID: ' . $order_id;
    }
}

    echo "<div class='dpd-formb' style='padding: 1em 1.4em;'>
		<form method='post'>
        <label for='order_id_input'><strong>Enter Order ID:</strong></label>
        <input type='text' name='order_id_input' id='order_id_input'>
        <input type='submit' class='button-primary' value='Get Tracking Numbers'>
    </form>
		</div>";	
echo '</div>';

	echo '</div>';		//End All Tabs Div
	
	echo '</div>';
}



//add_action( 'woocommerce_order_status_completed', 'insert_to_db' );
//add_filter( 'woocommerce_payment_complete_order_status', 'insert_to_db', 10, 2 );
function insert_to_db($order_id, $predict_function, $shipping_date, $parcel_content, $parcel_index, $total_weight ){
	global $wpdb;
	global $woocommerce;
	$table_name = $wpdb->prefix . 'dpd_orders';

	$order = new WC_Order( $order_id);
	
	// Retrieve DPD options
    $dpd_options = get_option('dpd_options');
    $order_total = $order->get_total(); // Assuming $order is WC_Order object
	$store_currency = get_woocommerce_currency();
	$total_insurance_value = $order_total;
	
    $insurance = array(); // Default empty

    // Check for higher insurance
    if (
		!empty($dpd_options['dpd_label_higher_insurance']) &&
		$order_total > 520
	)
		{
    $insurance_json = ',
        "HigherInsurance": {
            "Amount": "' . $total_insurance_value . '",
            "Currency": "' . $store_currency . '"
        }';
		
		/*$amount = isset($dpd_options['dpd_label_higher_insurance_amount']) ? (int)$dpd_options['dpd_label_higher_insurance_amount'] : 0;

		if ($amount > 0) {
			$insurance = array(
				'amount' => $amount,
			);
		} */
	}
	
	/* Partner Credentials */
	$partner_name = 'WooCommerce';
	$partner_token = 'B6A51536F6C5052702F7';
	
	/* Client Credentials */
	$cloud_user_id = absint( ice_get_option( 'dpd_client_user_id', 'dpd_options' ) );
	$user_token = ice_get_option( 'dpd_client_token', 'dpd_options' );
	
	$version = 100;  // Webservice version number
	
	$language = 'en_EN';  // language
	
	$orderaction = "startOrder";
	$shipdate = "2016-07-22";
	
	if ( ice_get_option( 'pdf_page_size', 'dpd_options' ) == 'A6' ) {
		$page_size = "PDF_A6";
	}
	else {
		$page_size = "PDF_A4";
	}
	
	$labelpos = "UpperLeft";
	if( ice_get_option( 'dpd_label_position', 'dpd_options' ) ){
		$labelpos = ice_get_option( 'dpd_label_position', 'dpd_options' );
	}

	$salutation = str_replace( ";", " ", ice_get_option( 'dpd_salutation', 'dpd_options' ) );
			$name = '';
		if ($order->get_shipping_first_name() && $order->get_shipping_last_name()) {
			$name = str_replace(";", " ", $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name());
		} else {
			$name = str_replace(";", " ", $order->get_billing_first_name() . ' ' . $order->get_billing_last_name());
		}

		$address = '';
		if ($order->get_shipping_address_1()) {
			$address = str_replace(";", " ", $order->get_shipping_address_1());
		} else {
			$address = str_replace(";", " ", $order->get_billing_address_1());
		}
	/*if($order->get_shipping_address_2()){
		$address .= ', '.str_replace( ";", " ", $order->get_shipping_address_2() );
	}*/
	

			$company = '';
		if (!empty($order->get_shipping_company())) {
			$company = str_replace(";", " ", $order->get_shipping_company());
		} else {
			$company = null;
		}

	//If user has opted for non manual(automatic) selection of parcel weights and has also not provided the weight for the selected parcel, then we find weight via following automatic method.
	if (!($total_weight and ice_get_option( 'dpd_multiple_shipping_labels', 'dpd_options' ) == 'manual'))
		{
			//Check original total weight and figure weight for existing parcel index within loop.
			$total_weight = dpd_get_total_weight($order_id);
			$parcel_weight_limit = 31.5;	//Kilogram
			if( $total_weight > $parcel_weight_limit )
				{
					$number_of_parcels = ceil($total_weight / $parcel_weight_limit);
					$number_of_parcels_check = floor($total_weight / $parcel_weight_limit);
					$last_parcel_number = $number_of_parcels;
					//$last_parcel_weight = $total_weight % $parcel_weight_limit;
					$last_parcel_weight = $total_weight - ($number_of_parcels_check * $parcel_weight_limit);
					//echo "<br>Last Parcel Weight: ".$last_parcel_weight;
					
					if($parcel_index == $last_parcel_number)
						{
							$total_weight = $last_parcel_weight;	
						}
					else
						{
							$total_weight = $parcel_weight_limit;	
						}
				}
		}
	//////////////
		
		
				$zipcode = '';
			if ($order->get_shipping_postcode()) {
				$zipcode = $order->get_shipping_postcode();
			} else {
				$zipcode = $order->get_billing_postcode();
			}
				$city = '';
			if ($order->get_shipping_city()) {
				$city = str_replace(";", " ", $order->get_shipping_city());
			} else {
				$city = str_replace(";", " ", $order->get_billing_city());
			}

				//$state = str_replace( ";", " ", $order->get_shipping_state() );
				$state = '';	//Using State Name causes an issue (CLOUD_STATE_STATESHORT)
				$country = '';
			if ($order->get_shipping_country()) {
				$country = str_replace(";", " ", strlen($order->get_shipping_country()) >= 35 ? substr($order->get_shipping_country(), 0, 34) : $order->get_shipping_country());
			} else {
				$country = str_replace(";", " ", strlen($order->get_billing_country()) >= 35 ? substr($order->get_billing_country(), 0, 34) : $order->get_billing_country());
			}

				$phone = '';
			if (get_post_meta($order->get_id(), '_shipping_phone', true)) {
				$phone = str_replace(";", "", get_post_meta($order->get_id(), '_shipping_phone', true));
			} else {
				$phone = str_replace(";", "", $order->get_billing_phone());
			}
				$mail = '';
			if (get_post_meta($order->get_id(), '_shipping_email', true)) {
				$mail = str_replace(";", "", get_post_meta($order->get_id(), '_shipping_email', true));
			} else {
				$mail = str_replace(";", "", $order->get_billing_email());
			}
	
	/* dpd disable order tracking */
	//$disable_track = ice_get_option( 'dpd_disable_order_tracking', 'dpd_options' );
	/* Parcel data */
	
	$internalID = "";
	$content = "";

	$reference_1 = str_replace( ";", " ", str_replace( '[order_number]', $order_id, ice_get_option( 'dpd_reference_1', 'dpd_options' ) ) );
	$reference_2 = str_replace( ";", " ",  str_replace( '[order_number]', $order_id, ice_get_option( 'dpd_reference_2', 'dpd_options' ) ) );
	
	
	
	
	
	
	$shipping_method = $order->get_shipping_method();
	$dpd_cl_array = explode( ",", ice_get_option( 'dpd_cl', 'dpd_options' ) );
	$dpd_cl_cod_array = explode( ",", ice_get_option( 'dpd_cl_cod', 'dpd_options' ) );
	$dpd_e18_array = explode( ",", ice_get_option( 'dpd_e18', 'dpd_options' ) );
	$dpd_e18_cod_array = explode( ",", ice_get_option( 'dpd_e18_cod', 'dpd_options' ) );
	$dpd_e830_array = explode( ",", ice_get_option( 'dpd_e830', 'dpd_options' ) );
	$dpd_e830_cod_array = explode( ",", ice_get_option( 'dpd_e830_cod', 'dpd_options' ) );
	$dpd_e10_array = explode( ",", ice_get_option( 'dpd_e10', 'dpd_options' ) );
	$dpd_e10_cod_array = explode( ",", ice_get_option( 'dpd_e10_cod', 'dpd_options' ) );
	$dpd_e12_array = explode( ",", ice_get_option( 'dpd_e12', 'dpd_options' ) );
	$dpd_e12_cod_array = explode( ",", ice_get_option( 'dpd_e12_cod', 'dpd_options' ) );
	$dpd_e12_saturday_array = explode( ",", ice_get_option( 'dpd_e12_saturday', 'dpd_options' ) );
	$dpd_express_international_array = explode( ",", ice_get_option( 'dpd_express_international', 'dpd_options' ) );
	$dpd_shop_delivery_array = explode( ",", ice_get_option( 'dpd_shop_delivery', 'dpd_options' ) );
	$dpd_shop_return_array = explode( ",", ice_get_option( 'dpd_shop_return', 'dpd_options' ) );
	$dpd_cl_return_array = explode( ",", ice_get_option( 'dpd_cl_return', 'dpd_options' ) );

	$shipservice = "Classic";
	if ( ! empty ( $shipping_method ) ) {
	
		foreach( $dpd_cl_cod_array as $dpd_cl_cod ) {
			if( $shipping_method == $dpd_cl_cod ) {
				$shipservice = "Classic_COD";
			}
		}
		
		foreach( $dpd_e18_array as $dpd_e18 ) {
			if( $shipping_method == $dpd_e18 ) {
				$shipservice = "Express_18";
			}
		}
		foreach( $dpd_e18_cod_array as $dpd_e18_cod ) {
			if( $shipping_method == $dpd_e18_cod ) {
				$shipservice = "Express_18_COD";
			}
		}
		foreach( $dpd_e830_array as $dpd_e830 ) {
			if( $shipping_method == $dpd_e830 ) {
				$shipservice = "Express_830";
			}
		}
		
		foreach( $dpd_e830_cod_array as $dpd_e830_cod ) {
			if( $shipping_method == $dpd_e830_cod ) {
				$shipservice = "Express_830_COD";
			}
		}
		foreach( $dpd_e10_array as $dpd_e10 ) {
			if( $shipping_method == $dpd_e10 ) {
				$shipservice = "Express_10";
			}
		}
		foreach( $dpd_e10_cod_array as $dpd_e10_cod ) {
			if( $shipping_method == $dpd_e10_cod ) {
				$shipservice = "Express_10_COD";
			}
		}
		foreach( $dpd_e12_array as $dpd_e12 ) {
			if( $shipping_method == $dpd_e12 ) {
				$shipservice = "Express_12";
			}
		}
		foreach( $dpd_e12_cod_array as $dpd_e12_cod ) {
			if( $shipping_method == $dpd_e12_cod ) {
				$shipservice = "Express_12_COD";
			}
		}
		foreach( $dpd_e12_saturday_array as $dpd_e12_saturday ) {
			if( $shipping_method == $dpd_e12_saturday ) {
				$shipservice = "Express_12_Saturday";
			}
		}
		foreach( $dpd_express_international_array as $dpd_express_international ) {
			if( $shipping_method == $dpd_express_international ) {
				$shipservice = "Express_International";
			}
		}
		
		foreach( $dpd_shop_delivery_array as $dpd_shop_delivery ) {
			if( $shipping_method == $dpd_shop_delivery ) {
				$shipservice = "Shop_Delivery";
			}
		}
		foreach( $dpd_shop_return_array as $dpd_shop_return ) {
			if( $shipping_method == $dpd_shop_return ) {
				$shipservice = "Shop_Return";
			}
		}
		foreach( $dpd_cl_return_array as $dpd_cl_return ) {
			if( $shipping_method == $dpd_cl_return ) {
				$shipservice = "Classic_Return";
			}
		}
	}

	if( ( $predict_function == "ON" ) && ( $shipservice == "Classic" || $shipservice == "Classic_COD" ) ){
		$shipservice = $shipservice.'_Predict';
	}
		
	if(preg_match('/^\d+/', $address, $array)) 
		{
			$pattern = '/(?=\s)/';
			$array = preg_split($pattern, $address, 2);
			$houseno = '';	if(isset($array[0]) and $array[0])	$houseno = $array[0];
			$address = '';	if(isset($array[1]) and $array[1])	$address = $array[1];
		}
	else
		{
			$pattern = '/(?=\d)/';
			$array = preg_split($pattern, $address, 2);
			$address = '';	if(isset($array[0]) and $array[0])	$address = $array[0];
			$houseno = '';	if(isset($array[1]) and $array[1])	$houseno = $array[1];	
		}

	$address = str_replace( ";", " ", strlen ( $address ) > 34 ? substr( $address, 0 , 34 ) : $address );

	/* if($order->get_shipping_address_2()){
		$address .= ', '.str_replace( ";", " ", $order->get_shipping_address_2() );
	} */

	
	if( $predict_function == "ON" ) {
		$ship_address =  '"ShipAddress":{
			"Company": "'.$company.'",
			"Salutation": "'.$salutation.'",
			"Name": "'.$name.'",
			"Street": "'.$address.'",
			"HouseNo": "'.$houseno.'",
			"ZipCode": "'.$zipcode.'",
			"City": "'.$city.'",
			"State": "'.$state.'",
			"Country": "'.$country.'",
			"Mail": "'.$mail.'"
		}';

		if( ice_get_option( 'dpd_label_phone_no', 'dpd_options' ) == '1' ) {
			$ship_address =  '"ShipAddress":{
				"Company": "'.$company.'",
				"Salutation": "'.$salutation.'",
				"Name": "'.$name.'",
				"Street": "'.$address.'",
				"HouseNo": "'.$houseno.'",
				"ZipCode": "'.$zipcode.'",
				"City": "'.$city.'",
				"State": "'.$state.'",
				"Country": "'.$country.'",
				"Mail": "'.$mail.'",
				"Phone": "'.$phone.'"
			}';
		}
	}
	else {
		$ship_address = '"ShipAddress":{
			"Company": "'.$company.'",
			"Salutation": "'.$salutation.'",
			"Name": "'.$name.'",
			"HouseNo": "'.$houseno.'",
			"Street": "'.$address.'",
			"ZipCode": "'.$zipcode.'",
			"City": "'.$city.'",
			"State": "'.$state.'",
			"Country": "'.$country.'"
		}';

		if( ice_get_option( 'dpd_label_phone_no', 'dpd_options' ) == '1' ) {
			$ship_address = '"ShipAddress":{
				"Company": "'.$company.'",
				"Salutation": "'.$salutation.'",
				"Name": "'.$name.'",
				"HouseNo": "'.$houseno.'",
				"Street": "'.$address.'",
				"ZipCode": "'.$zipcode.'",
				"City": "'.$city.'",
				"State": "'.$state.'",
				"Country": "'.$country.'",
				"Phone": "'.$phone.'"
			}';
		}
	}
	
	
// 	if ( ice_get_option('dpd_debug', 'dpd_options') == 1 ) {
// 		echo 'Page Size: '.$page_size.'<br />';
// 		echo 'Label Position: '.$labelpos.'<br />';
// 		echo 'Shipping Service: '.$shipservice.'<br />';
// 		echo 'Shipping Date: '.$shipping_date.'<br />';
// 		echo 'Parcel Content: '.str_replace( ";", " ", $parcel_content ).'<br />';
// 		echo 'Predict Funcion: '.$predict_function.'<br />';
// 		echo 'Company: '.$company.'<br />';
// 		echo 'Name: '.$name.'<br />';
// 		echo 'Address: '.$address.'<br />';
//     	echo 'House No: '.$houseno.'<br />';
// 		echo 'Country: '.$country.'<br />';
// 		echo 'PostCode: '.$zipcode.'<br />';
// 		echo 'City: '.$city.'<br />';
// 		echo 'Weight: '.$total_weight.'<br />';
// 		echo 'Referez 1: '.$reference_1.'<br />';
// 		echo 'Referez 2: '.$reference_2.'<br />';
// 	}
	
$myRestApiGetCall = 'https://cloud.dpd.com/api/v1/setOrder';

/*$cod = '';
if($order->get_payment_method() == 'cod'){
	$shipservice = 'Classic_COD';
	$cod = '"COD":{
		"Purpose": "'.$order_id.'",
		"Amount": "'.$order->get_total().'"
	}';
	if(ice_get_option('dpd_debug', 'dpd_options') == 1 ){
		echo 'COD Purpose: '.$order_id.'<br />';
		echo 'COD Amount: '.$order->get_total();
	}
} */

//$shipservice = "Express_International";
//$shipservice = "PARCELLetter";
/* Code total orderamount + insurance amount */
//$insurance_amount = isset($insurance['amount']) ? $insurance['amount'] : 0;
//$total_insurance_value = $order_total + $insurance_amount;
//$total_insurance_value = $order_total;
	
$mySetOrderJSONString= '{
	"OrderAction":"startOrder",
	"OrderSettings":{
		"ShipDate": "'.$shipping_date.'",
		"LabelSize": "'.$page_size.'",
		"LabelStartPosition": "'.$labelpos.'"
	},
	"OrderDataList":[{
		
		'.$ship_address.',
		"ParcelData":{
			"YourInternalID":"123",
			"Content": "'.$parcel_content.'",
			"Weight": "'.$total_weight.'",
			"Reference1": "'.$reference_1.'",
			"Reference2": "'.$reference_2.'",
			  "ShipService": "' . $shipservice . '"' .
            $insurance_json .
            $cod . '
		}
	}]
}';
//  	error_reporting(E_ALL);
//  ini_set('display_errors', '1');
$ch = curl_init();
$headers  = array(
      'Content-Type:application/json', 
	   "Accept:application/json",
      'Version:' . $version,
      'Language:' . $language,
	  'PartnerCredentials-Name:' . $partner_name,
	  'PartnerCredentials-Token:' . $partner_token,
	  'UserCredentials-cloudUserID:' . $cloud_user_id,
      'UserCredentials-Token:' . $user_token);

curl_setopt($ch, CURLOPT_URL,$myRestApiGetCall);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $mySetOrderJSONString);           
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$setOrderResponse     = curl_exec ($ch);
$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$error_message = curl_error($ch); // Get error message
$result = json_decode( $setOrderResponse );	
	//echo $setOrderResponse;die;
	//print_r();die;
//echo '<pre>' . htmlspecialchars($mySetOrderJSONString) . '</pre>';
	//die();
//echo "<pre>"; print_r( json_decode( $mySetOrderJSONString ));echo'</pre>'; exit;
	//die();
if( $result->Ack == false ){
	foreach( $result->ErrorDataList as $error ){
		echo '<b>Error Code:</b> '.$error->ErrorCode.'<br />';
		echo '<b>Error Long Message:</b> '. $error->ErrorMsgLong.'<br />';
		echo '<br />';
	}
	return -1; 
}
else {
	
	 $wpdb->insert($table_name,array(
		'order_id' => $order_id,
		'weight' => $total_weight,
		'parcel_number' => $result->LabelResponse->LabelDataList[0]->ParcelNo,
		'pdf_data' => $result->LabelResponse->LabelPDF,
		'page_size' => $page_size,
		'shipping_method' => $shipservice,
		'reference_1' =>$reference_1,
		'reference_2' => $reference_2,
		'predict_function' => $predict_function,
		'date' => strtotime ( $result->TimeStamp ),
		'shipping_date' => strtotime( $shipping_date )
	));
	return $wpdb->insert_id;
	//echo $wpdb->last_query;
	//die();
}

}
 
add_action('wp','get_auth');
function get_auth(){
	global $wpdb;
	$table_name = $wpdb->prefix . 'dpd_orders';
	if(isset($_GET['dpd_id']) && $_GET['dpd_id'] && is_user_logged_in() && current_user_can('edit_posts')) {
		$id = absint ( $_GET['dpd_id'] );
		$row = $wpdb->get_row("SELECT * FROM $table_name WHERE id = $id");
		ob_clean();
		header('Content-type: application/pdf');
		echo base64_decode($row->pdf_data);
		exit;
	}
	else {
		// Silence is gold.		
	}
}

add_action('add_meta_boxes', 'dpd_meta_box');

function dpd_meta_box() {
   global $post;

    // Check if $post is an object
    //if (!is_object($post)) {
      //  return;
    //}

  $isPrime = false;
    $amazon_order_id = get_post_meta($post->ID, '_wpla_amazon_order_id', true);

    if ($amazon_order_id) {
        $om = new WPLA_OrdersModel();
        $order = $om->getOrderByOrderID($amazon_order_id);
        if ($order) {
            $order_details = json_decode($order->details);
            if (is_object($order_details) && isset($order_details->IsPrime) && $order_details->IsPrime == 'true') {
                $isPrime = true;
            }
        }
    }

    remove_meta_box('dpd-pdf-id', 'woocommerce_page_wc-orders', 'advanced');

    add_meta_box('dpd-pdf-id',__('DPD Shipping Label', 'dpd'),'show_dpd_pdf','woocommerce_page_wc-orders','side');
    
    remove_meta_box('dpd-pdf-id', 'shop_order', 'advanced');

    add_meta_box('dpd-pdf-id',__('DPD Shipping Label', 'dpd'),'show_dpd_pdf','shop_order','side');
}


function show_dpd_pdf($post) {
    global $wpdb;
    $order_id = $post->ID;
    $table_name = $wpdb->prefix . 'dpd_orders';
    $parcels = $wpdb->get_results("SELECT id, parcel_number, date FROM $table_name WHERE order_id = $order_id AND (order_type != 'amazon_prime' OR order_type IS NULL) AND status != 'trash'");
    $predict = $wpdb->get_var("SELECT predict_function FROM $table_name WHERE order_id = $order_id");

    echo '<div class="shipping-label-container">';
    if (count($parcels) > 0) {
        echo 'Predict function was <b>' . $predict . '</b> for this order.<br><br>';
        foreach ($parcels as $parcel) {
            echo '<strong>Tracking/Parcel Number:</strong> <a href="https://tracking.dpd.de/parcelstatus?query=' . $parcel->parcel_number . '&locale=de_DE" class="parcel-label-number" target="_blank">' . $parcel->parcel_number . '</a>';
            echo '<input type="hidden" id="parcel-label-date" value="' . date('M Y, d H:i', $parcel->date) . '"/>';
            echo '<br><br>';
            echo '<a href="' . get_home_url() . '/?dpd_id=' . $parcel->id . '" class="button button-primary download-shipping-label" target="_blank">Download PDF</a><br>';
        }
        echo '<br />';
        echo '<div class="button button-delete delete-shipping-label" id="order_id-' . $order_id . '" style="float:right;">Delete</div> ';
        echo '<br /><br />';
    } else {
        echo 'Shipping Label has not yet been created. Please create one.<br><br>';
        echo 'DPD Predict<br>';
        echo '<input type="radio" name="predict-function-control" id="predict-function-control" value="ON" ';
        if (ice_get_option('dpd_predict_function_default', 'dpd_options') == 'ON') {
            echo 'checked="checked"';
        }
        echo '/> ON';
        echo '&nbsp;&nbsp;<input type="radio" name="predict-function-control" id="predict-function-control" value="OFF" ';
        if (ice_get_option('dpd_predict_function_default', 'dpd_options') == 'OFF') {
            echo 'checked="checked"';
        }
        echo '/> OFF';
        echo '<br><br>';

        if (ice_get_option('dpd_multiple_shipping_labels', 'dpd_options') == 'manual') {
            $total_weight = dpd_get_total_weight($order_id);
            echo 'Enter comma separated weights for individual parcels to be created (Ex. 3,8.5,17,5.5 to create 4 labels with these weights)';
            echo '<input type="text" name="manual_parcel_weights" id="manual-parcel-weights"></input>';
            echo '<br /><em>(Total order weight is: ' . $total_weight . ')</em>';
            echo '<br /><br />';
        }

        $default_ship_date = gmdate('Y-m-d', strtotime(get_option('gmt_offset') . ' hours'));
        $is_weekend = date('N', strtotime($default_ship_date)) >= 6;
        if (ice_get_option('dpd_auto_monday', 'dpd_options') == '1' && $is_weekend) {
            $default_ship_date = date('Y-m-d', strtotime('next monday'));
        }
        echo '<label for="ship-date">Shipping Date: </label>';
        echo '<input type="text" name="ship_date" value="' . $default_ship_date . '" class="ship_date_cls_de" id="ship-date" />';
        echo '<br /><br />';
        echo '<label for="dpd-content">Parcel Content Description: </label>';
        echo '<input type="text" name="dpd_content" value="' . ice_get_option('dpd_content', 'dpd_options') . '" id="dpd-content" />';
        echo '<br /><br>';

        echo '<input type="checkbox" name="disable_order_completion" value="1" />';
        echo '<label for="disable_order_completion">Disable Order Completion</label>';
        echo '<br /><br />';

        echo '<div class="create-shipping-label button button-primary" id="shipping_order-' . $order_id . '">Create Shipping Label</div>';
        echo '<div class="shipping-label-in-process" style="display:none;">Shipping Label is being created...</div>';
    }
    echo '</div>';
/* code update shipping method in order details page add here */
// Handle form submission
$success_message = '';
if (isset($_GET['change_shipping_method'])) {
$selected_shipping_method = $_GET['dpd_shipping_method'];
 $order_id = $_GET['order_id'];
	
    global $wpdb;
    $table_name = $wpdb->prefix . 'dpd_orders';
    
    // Prepare and execute the SQL query to update shipping method
    $sql = $wpdb->prepare("UPDATE $table_name SET shipping_method='$selected_shipping_method' WHERE order_id=$order_id");

    if ($wpdb->query($sql) !== false) {
        $success_message = '<p style="color:#000000;"><strong>Data updated successfully!</strong></p>';
    } else {
        $success_message = '<p style="color:red;">Error updating data: ' . $wpdb->last_error . '</p>';
    }
}	
global $wpdb;
$table_name = $wpdb->prefix . 'dpd_orders';
$current_shipping_method = $wpdb->get_var($wpdb->prepare("SELECT shipping_method FROM $table_name WHERE order_id = %d", $order_id));	
	
$options = get_option('dpd_options');

// Retrieve shipping method values from plugin options
$dpd_cl = isset($options['dpd_cl']) ? $options['dpd_cl'] : '';
$dpd_cl_cod = isset($options['dpd_cl_cod']) ? $options['dpd_cl_cod'] : '';
$dpd_e18 = isset($options['dpd_e18']) ? $options['dpd_e18'] : '';
$dpd_e18_cod = isset($options['dpd_e18_cod']) ? $options['dpd_e18_cod'] : '';
$dpd_e830 = isset($options['dpd_e830']) ? $options['dpd_e830'] : '';
$dpd_e830_cod = isset($options['dpd_e830_cod']) ? $options['dpd_e830_cod'] : '';
$dpd_e10 = isset($options['dpd_e10']) ? $options['dpd_e10'] : '';
$dpd_e10_cod = isset($options['dpd_e10_cod']) ? $options['dpd_e10_cod'] : '';
$dpd_e12 = isset($options['dpd_e12']) ? $options['dpd_e12'] : '';
$dpd_e12_cod = isset($options['dpd_e12_cod']) ? $options['dpd_e12_cod'] : '';
$dpd_e12_saturday = isset($options['dpd_e12_saturday']) ? $options['dpd_e12_saturday'] : '';
$dpd_express_international = isset($options['dpd_express_international']) ? $options['dpd_express_international'] : '';
$dpd_shop_delivery = isset($options['dpd_shop_delivery']) ? $options['dpd_shop_delivery'] : '';
$dpd_shop_return = isset($options['dpd_shop_return']) ? $options['dpd_shop_return'] : '';
$dpd_cl_return = isset($options['dpd_cl_return']) ? $options['dpd_cl_return'] : '';

// Define your shipping methods
$shipping_methods = array(
    'Classic' => $dpd_cl,
    'Classic_COD' => $dpd_cl_cod,
    'Express_18' => $dpd_e18,
    'Express_18_COD' => $dpd_e18_cod,
    'Express_830' => $dpd_e830,
    'Express_830_COD' => $dpd_e830_cod,
    'Express_10' => $dpd_e10,
    'Express_10_COD' => $dpd_e10_cod,
    'Express_12' => $dpd_e12,
    'Express_12_COD' => $dpd_e12_cod,
    'Express_12_Saturday' => $dpd_e12_saturday,
    'Express_International' => $dpd_express_international,
    'Shop_Delivery' => $dpd_shop_delivery,
    'Shop_Return' => $dpd_shop_return,
    'Classic_Return' => $dpd_cl_return
);

// Output the shipping methods
echo '<h4>' . __('Shipping Method', 'dpd-shipping-label') . '</h4>';
echo '<div class="feild">';
echo '<input type="hidden" name="order_id" value="' . esc_attr($order_id) . '">';

echo '<select name="dpd_shipping_method" id="dpd_shipping_method" style="margin-bottom:10px;">'; // Corrected name attribute

foreach ($shipping_methods as $method => $value) {
	if (!empty($value)) {
     $selected = '';
		if($current_shipping_method == $method){
			$selected = 'selected';
		}
		echo '<option value="' . $method . '" '.$selected.'>' . $value . '</option>';
	}	
}
echo '</select>';
echo '</div>';
echo '<div class="feild">';
echo '<button type="button" onclick="updateShippingMethod('.esc_attr($order_id).');" name="change_shipping_method" class="button">' . __('Change Shipping Method', 'dpd-shipping-label') . '</button>';
echo '</div>';
echo $success_message;
?>
<script>
    function updateShippingMethod(order_id){
   var shipping_method = jQuery('#dpd_shipping_method').val();
   var current_url = window.location.href;
   window.location.href = current_url+'&change_shipping_method=true&dpd_shipping_method='+shipping_method+'&order_id='+order_id;
}
</script>
<?php
	    // Handle form submission
     /*   if (isset($_POST['change_shipping_method'])) {
    $selected_shipping_method = $_POST['dpd_shipping_method'];
     $order_id = $_POST['order_id'];
        global $wpdb;
        $table_name = $wpdb->prefix . 'dpd_orders';
        
        // Prepare and execute the SQL query to update shipping method
        $sql = $wpdb->prepare("UPDATE $table_name SET shipping_method='%s' WHERE order_id=%d", $selected_shipping_method, $order_id);

        if ($wpdb->query($sql) !== false) {
            echo '<p style="color:#000000;"><strong>Shipping Method Updated Successfully!</strong></p>';
        } else {
            echo '<p style="color:red;">Error updating data: ' . $wpdb->last_error . '</p>';
        }
	} */
}

function dpd_add_ajaxurl_cdata_to_front(){ ?>
    <script type="text/javascript"> //<![CDATA[
        ajaxurl = '<?php echo admin_url( 'admin-ajax.php'); ?>';
    //]]> </script>
<?php }
add_action( 'admin_head', 'dpd_add_ajaxurl_cdata_to_front', 1);

add_action('admin_head','ajax_dpd');
function ajax_dpd(){
	?>
		<script type="text/javascript"> 
			var predict_function = '';
			jQuery(document).ready(function($){
				jQuery(".shipping-label-container").on("click", ".create-shipping-label", function(){
					var id_array = jQuery(this).attr("id");
					var id = id_array.split("-");
					var disable_order_completion = false;
					if(jQuery('input[name="disable_order_completion"]').is(":checked")){
						disable_order_completion = true;
					}
					var ajaxdata = {
						action: "create_label",
						order_id: id[1],
						predict_function: jQuery("#predict-function-control:checked").val(),
						//number_of_parcels: jQuery("#number-of-parcels option:selected").val(),
						manual_parcel_weights: jQuery("#manual-parcel-weights").val(),
						shipping_date: jQuery("#ship-date").val(),
						parcel_content: jQuery("#dpd-content").val(),
						disable_order_completion: disable_order_completion
					}
					jQuery(".shipping-label-in-process").show();
					jQuery.post(ajaxurl, ajaxdata, function(res){
						if(typeof res =='object'){
							console.log(res);
							jQuery(".shipping-label-container").empty();
							jQuery(".shipping-label-container").append(res['msg']);
							if(res['error_found'] == false && res['reload'] == true){
								var url = jQuery('.download-shipping-label').attr('href');
								window.open(url, '_blank'); 
								location.reload();
							}
						}
					});
				});

				jQuery("body").on("click", ".create_dpd_label", function(e){
					e.preventDefault();
					var $ele = jQuery(this);
					$ele.prop('disabled', true);
					var href = jQuery(this).attr('href');
					var ajaxdata = {
						action: "create_label",
						order_id: getParameterByName('post', href),
						predict_function: "<?php echo ice_get_option( 'dpd_predict_function_default', 'dpd_options' ); ?>",
						//number_of_parcels: '1',
						shipping_date: "<?php echo gmdate ( 'Y-m-d', strtotime ( get_option ( 'gmt_offset' ).' hours' ) ); ?>",
						parcel_content: "<?php echo ice_get_option( 'dpd_content', 'dpd_options' ); ?>"
					}
					//jQuery(".shipping-label-in-process").show();
					jQuery.post(ajaxurl, ajaxdata, function(res){
						if(typeof res =='object'){
							console.log(res);
							jQuery(".shipping-label-container").empty();
							jQuery(".shipping-label-container").append(res['msg']);
							if(res['error_found'] == false && res['reload'] == true){
      					var url = res['reload_url'];
								window.open(url, '_blank'); 
      					location.reload();
								$ele.remove();
							}
							else{
								alert("There was problem while creating shipping label.");
							}
						}
						$ele.prop('disabled', false);
					});
				});

				function getParameterByName(name, url) {
					if (!url) url = window.location.href;
					name = name.replace(/[\[\]]/g, "\\$&");
					var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
						results = regex.exec(url);
					if (!results) return null;
					if (!results[2]) return '';
					return decodeURIComponent(results[2].replace(/\+/g, " "));
				}
				
				jQuery(".shipping-label-container").on( "click", ".delete-shipping-label", function(){
					jQuery(".shipping-label-container").append("Deleting the shippig label...");
					
					var months = new Array(12);
				months[0] = "January";
				months[1] = "February";
				months[2] = "March";
				months[3] = "April";
				months[4] = "May";
				months[5] = "June";
				months[6] = "July";
				months[7] = "August";
				months[8] = "September";
				months[9] = "October";
				months[10] = "November";
				months[11] = "December";
				
				var parcel_num = '';
				jQuery(".parcel-label-number").each(function(){
					parcel_num += jQuery(this).text();
					parcel_num += ', ';
				});

				var now = new Date(); 
				var now_utc = new Date(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate(),  now.getUTCHours(), now.getUTCMinutes(), now.getUTCSeconds());
				
				var comment = "Parcel number " + parcel_num + " created on " + jQuery("#parcel-label-date").val() + " (UMT time) has been deleted";
				
					var id_array = jQuery(this).attr("id");
					var id = id_array.split("-"); 
					jQuery("#add_order_note").val(comment);
		
					$('#order_note_type option[selected="selected"]').each(
						function() {
							$(this).removeAttr('selected');
						}
					);

					$("#order_note_type option:first").attr('selected','selected');
					jQuery(".add_note").click();
					var ajaxdata = {
						action: "delete_label",
						order_id: id[1]
					}
					jQuery.post(ajaxurl, ajaxdata, function(res){
						jQuery(".shipping-label-container").empty();
						jQuery(".shipping-label-container").append(res);
					});
				});
			});
		</script>
	<?php
}

function dpd_get_total_weight($order_id)
	{
		$total_weight = '';
		if ( ice_get_option( 'dpd_calculate_weight', 'dpd_options' ) == 'default' ) 
			{
				$total_weight = absint( ice_get_option ( 'dpd_default_weight', 'dpd_options' ) );
			}
		else 
			{
				$total_weight = 0;
				$weight = 0;
				$item_weight = 0;
				$order = new WC_Order( $order_id);
				$items = $order->get_items();
				$woo_weight_unit = strtolower(get_option('woocommerce_weight_unit'));
				foreach( $items as $item ) {
					$product_id = $item['product_id'];
					$variation_id = 0;
					if($item['variation_id']){
						$variation_id = $item['variation_id'];
					}
		
					$prod_weight = 0;
					if($variation_id){
						$item_metas = get_post_meta($variation_id);
						$weight = 0;	if(isset($item_metas['_weight']['0']))	$weight = $item_metas['_weight']['0'];
						if($weight){
							$prod_weight = $weight;
						}
					}
		
					if(!$prod_weight){
						$item_metas = get_post_meta( $product_id );
						$weight = 0;	if(isset($item_metas['_weight']['0']))	$weight = $item_metas['_weight']['0'];
						$prod_weight = $weight;
					}
					
					
					$quantity = $item['qty'];
					if($woo_weight_unit == 'g'){
						if(isset($weight) and is_numeric($weight) and $weight > 0)	$weight = $weight/1000;
					}
					
					if(isset($weight) and is_numeric($weight) and isset($quantity) and is_numeric($quantity))
						{
							$item_weight = ( $weight * $quantity );
						}
					$total_weight += $item_weight;
				}
				
				//Add Packaging Weight
				$packaging_weight_grams = absint( ice_get_option ( 'dpd_packaging_weight', 'dpd_options' ) );
				$packaging_weight_kg = '';	if( isset( $packaging_weight_grams ) and $packaging_weight_grams and is_numeric($packaging_weight_grams) )	$packaging_weight_kg = $packaging_weight_grams/1000;

				if( $packaging_weight_kg and is_numeric($packaging_weight_kg) ){
					$total_weight = $total_weight + $packaging_weight_kg;
				}			
				
				$total_weight = round($total_weight, 2);
			}
		return $total_weight;	
	}

add_action('wp_ajax_create_label', 'create_label'); // Call when user logged in
add_action('wp_ajax_nopriv_create_label', 'create_label'); // Call when user in not logged in
function create_label($order_id = '', $response_type='ajax'){
	ob_start();
	$error_found = true;
	$reload = false;
	$json = array();
	global $wpdb;
	$table_name = $wpdb->prefix.'dpd_orders';
	if(isset($_POST['order_id']))	$order_id = $_POST['order_id'];
	
	$label_exists = get_order_shipping_label_number($order_id);
	
	
	if(!$label_exists)
		{
			$number_of_parcels = 1; 	
			//if(isset($_POST['number_of_parcels'])) $number_of_parcels = absint ( $_POST['number_of_parcels'] );		//Number of Parcels is calculated automatically
			$shipping_date = date('Y-m-d');
			$is_weekend = date('N', strtotime($shipping_date)) >= 6;
			if(ice_get_option( 'dpd_auto_monday', 'dpd_options' ) == '1' and $is_weekend)
				{
					$shipping_date = date('Y-m-d', strtotime('next monday'));
				}
			
			

			if(isset($_POST['shipping_date'])) $shipping_date = $_POST['shipping_date'];
		
			$parcel_content = ice_get_option( 'dpd_content', 'dpd_options' );	if(isset($_POST['parcel_content'])) $parcel_content = $_POST['parcel_content'];
			$disable_order_completion = 0;	if(isset($_POST['disable_order_completion'])) $disable_order_completion = $_POST['disable_order_completion'];
			
			$order =  new WC_Order( absint( $order_id ) );
			$shipping_method = $order->get_shipping_method();
			$dpd_cl_array = explode( ",", ice_get_option( 'dpd_cl', 'dpd_options' ) );
			$dpd_cl_cod_array = explode( ",", ice_get_option( 'dpd_cl_cod', 'dpd_options' ) );
			$dpd_e18_array = explode( ",", ice_get_option( 'dpd_e18', 'dpd_options' ) );
			$dpd_e18_cod_array = explode( ",", ice_get_option( 'dpd_e18_cod', 'dpd_options' ) );
			$dpd_e830_array = explode( ",", ice_get_option( 'dpd_e830', 'dpd_options' ) );
			$dpd_e830_cod_array = explode( ",", ice_get_option( 'dpd_e830_cod', 'dpd_options' ) );
			$dpd_e10_array = explode( ",", ice_get_option( 'dpd_e10', 'dpd_options' ) );
			$dpd_e10_cod_array = explode( ",", ice_get_option( 'dpd_e10_cod', 'dpd_options' ) );
			$dpd_e12_array = explode( ",", ice_get_option( 'dpd_e12', 'dpd_options' ) );
			$dpd_e12_cod_array = explode( ",", ice_get_option( 'dpd_e12_cod', 'dpd_options' ) );
			$dpd_e12_saturday_array = explode( ",", ice_get_option( 'dpd_e12_saturday', 'dpd_options' ) );
			$dpd_express_international_array = explode( ",", ice_get_option( 'dpd_express_international', 'dpd_options' ) );
			$dpd_shop_delivery_array = explode( ",", ice_get_option( 'dpd_shop_delivery', 'dpd_options' ) );
			$dpd_shop_return_array = explode( ",", ice_get_option( 'dpd_shop_return', 'dpd_options' ) );
			$dpd_cl_return_array = explode( ",", ice_get_option( 'dpd_cl_return', 'dpd_options' ) );
		
			$shipservice = "Classic";
			if ( ! empty ( $shipping_method ) ) {
				
			
			foreach( $dpd_cl_cod_array as $dpd_cl_cod ) {
				if( $shipping_method == $dpd_cl_cod ) {
					$shipservice = "Classic_COD";
				}
			}
			
			foreach( $dpd_e18_array as $dpd_e18 ) {
				if( $shipping_method == $dpd_e18 ) {
					$shipservice = "Express_18";
				}
			}
			foreach( $dpd_e18_cod_array as $dpd_e18_cod ) {
				if( $shipping_method == $dpd_e18_cod ) {
					$shipservice = "Express_18_COD";
				}
			}
			foreach( $dpd_e830_array as $dpd_e830 ) {
				if( $shipping_method == $dpd_e830 ) {
					$shipservice = "Express_830";
				}
			}
			
			foreach( $dpd_e830_cod_array as $dpd_e830_cod ) {
				if( $shipping_method == $dpd_e830_cod ) {
					$shipservice = "Express_830_COD";
				}
			}
			foreach( $dpd_e10_array as $dpd_e10 ) {
				if( $shipping_method == $dpd_e10 ) {
					$shipservice = "Express_10";
				}
			}
			foreach( $dpd_e10_cod_array as $dpd_e10_cod ) {
				if( $shipping_method == $dpd_e10_cod ) {
					$shipservice = "Express_10_COD";
				}
			}
			foreach( $dpd_e12_array as $dpd_e12 ) {
				if( $shipping_method == $dpd_e12 ) {
					$shipservice = "Express_12";
				}
			}
			foreach( $dpd_e12_cod_array as $dpd_e12_cod ) {
				if( $shipping_method == $dpd_e12_cod ) {
					$shipservice = "Express_12_COD";
				}
			}
			foreach( $dpd_e12_saturday_array as $dpd_e12_saturday ) {
				if( $shipping_method == $dpd_e12_saturday ) {
					$shipservice = "Express_12_Saturday";
				}
			}
			foreach( $dpd_express_international_array as $dpd_express_international ) {
				if( $shipping_method == $dpd_express_international ) {
					$shipservice = "Express_International";
				}
			}
		
			foreach( $dpd_shop_delivery_array as $dpd_shop_delivery ) {
				if( $shipping_method == $dpd_shop_delivery ) {
					$shipservice = "Shop_Delivery";
				}
			}
			foreach( $dpd_shop_return_array as $dpd_shop_return ) {
				if( $shipping_method == $dpd_shop_return ) {
					$shipservice = "Shop_Return";
				}
			}
			foreach( $dpd_cl_return_array as $dpd_cl_return ) {
				if( $shipping_method == $dpd_cl_return ) {
					$shipservice = "Classic_Return";
				}
			}
		}
			
			if( $shipservice == 'Classic' ) {
				$predict_function = ice_get_option( 'dpd_predict_function_default', 'dpd_options' ); if(isset($_POST['predict_function'])) $predict_function = $_POST['predict_function'];
			}
			else {
				$predict_function = "OFF";
			}
			//$parcel_detail[] = array();
			
			$total_weight = dpd_get_total_weight($order_id);
			$parcel_weight_limit = 31.5;	//Kilogram
			
			if (ice_get_option( 'dpd_multiple_shipping_labels', 'dpd_options' ) == 'manual') 
				{
					
					$number_of_parcels = 1;
					$manual_parcel_weights = '';	if(isset($_POST['manual_parcel_weights'])) $manual_parcel_weights = $_POST['manual_parcel_weights'];
					$manual_parcel_weights = array_map('trim',array_filter(explode(',',$manual_parcel_weights)));
					$is_numeric_weights = 1;
					foreach($manual_parcel_weights as $manual_parcel_weight)
						{
							if(!is_numeric($manual_parcel_weight))	
								{
									$is_numeric_weights = 0;		
								}
						}
					
					if($is_numeric_weights)
						{
							$error_found = false;
							$number_of_parcels = sizeof($manual_parcel_weights);
						}
					else
						{
							$number_of_parcels = 0;	
						}						
				}
			else
				{
					
					

					if( $total_weight > $parcel_weight_limit )
						{
							$number_of_parcels = ceil($total_weight / $parcel_weight_limit);
							$last_parcel_number = $number_of_parcels;
							$last_parcel_weight = $total_weight % $parcel_weight_limit;
						}
					else
						{
							$number_of_parcels = 1;	
						}
				}
			
			for ( $i = 1; $i <= $number_of_parcels; $i++) {
				$parcel_weight_number = $i - 1;
				$the_manual_parcel_weight = 0;	if(isset($manual_parcel_weights[$parcel_weight_number]) and $manual_parcel_weights[$parcel_weight_number])	$the_manual_parcel_weight = $manual_parcel_weights[$parcel_weight_number];
				$id = insert_to_db($order_id, $predict_function, $shipping_date, $parcel_content, $i, $the_manual_parcel_weight );
				if( $id != -1 ) {
					$error_found = false;  
					$row = $wpdb->get_var("SELECT parcel_number FROM $table_name WHERE id = $id");
					$date_created = $wpdb->get_var("SELECT date FROM $table_name WHERE id = $id");
			  
					if ( ! empty ( $row ) && $row ) {
						$parcel_detail[] = array ( 
							'id' => $id,
							'parcel_num' => $row,
							'date' => $date_created
						);
						add_post_meta( $order_id, 'dpd_parcel_number', $row );
					}
				}
			}
		

			if( $number_of_parcels and $parcel_detail && count ( $parcel_detail ) > 0 ) {
				if(ice_get_option( 'dpd_auto_completed', 'dpd_options' ) == '1' && (!isset($disable_order_completion) || $disable_order_completion == false || $disable_order_completion == 'false')){
					if (!empty($order)) {
						
						$order->update_status( 'completed' );
					}
					echo 'Order has been marked as completed.<br><br>';
				}
				$reload = true;
				$reload_url = get_site_url().'?dpd_id='.$parcel_detail[0]['id'];
				foreach ( $parcel_detail as $parcel ) {
					echo '<strong>Tracking/Parcel Number:</strong> <a href="https://tracking.dpd.de/parcelstatus?query='.$parcel["parcel_num"].'&locale=de_DE" class="parcel-label-number" target="_blank">'.$parcel["parcel_num"].'</a>';
					echo '<input type="hidden" id="parcel-label-date" value="'.date('M Y, d H:i', $parcel["date"]).'"/>';
					echo '<br><br>';
					echo '<a href="'.get_home_url().'/?dpd_id='.$parcel["id"].'" class="button button-primary download-shipping-label" target="_blank">Download PDF</a><br>';
				}
				echo '<br />';
				echo '<div class="button button-delete delete-shipping-label" id="order_id-'.$order_id.'" style="float:right;">Delete</div> ';
				echo '<br /><br />';
				do_action( 'dpd_shipping_label_created', $parcel_detail );
			}
			else {
				update_post_meta($order_id, 'dpd_error', '1');
				$error_found = true;
				echo 'Failed to create Shipping Label. :(';
			}
			$msg = ob_get_clean();
			$json['msg'] = $msg;
			$json['error_found'] = $error_found;
			$json['reload'] = $reload;
		  	$json['reload_url'] = $reload_url;
		  }
		if($response_type == 'return')
			{
				return $error_found;
			}
		else
			{  
				wp_send_json($json);
				die;
			}	
}

add_action('wp_ajax_delete_label', 'delete_label');
add_action('wp_ajax_nopriv_delete_label', 'delete_label');
function delete_label(){
	$order_id = absint ( $_POST['order_id'] );
	global $wpdb;
	$table_name = $wpdb->prefix.'dpd_orders';
	
	
	$deleted_rows = $wpdb->update($table_name, array('status'	=> 'trash'), array( 'order_id' => $order_id ) );
	if ( $deleted_rows ) {
		echo 'Shipping Label has not yet been created. Please create one.<br><br>';
		echo 'DPD Predict<br>';
		echo '<input type="radio" name="predict-function-control" id="predict-function-control" value="ON" ';
		if (ice_get_option( 'dpd_predict_function_default', 'dpd_options' ) == 'ON') {
			echo 'checked="checked"';
		}
		echo '/> ON';
		echo ' <input type="radio" name="predict-function-control" id="predict-function-control" value="OFF" ';
		if (ice_get_option( 'dpd_predict_function_default', 'dpd_options' ) == 'OFF') {
			echo 'checked="checked"';
		}
		echo '/> OFF';
		echo '<br><br>';
		echo 'How many parcels to create';
		echo '<select name="parcels" id="number-of-parcels">';
		for ( $i=1;$i<10;$i++) {
			echo '<option value="'.$i.'">'.$i.'</option>';
		}
		echo '</select>';
		echo '<br /><br />';

		$default_ship_date = gmdate ( 'Y-m-d', strtotime ( get_option ( 'gmt_offset' ).' hours' ) );
		$is_weekend = date('N', strtotime($default_ship_date)) >= 6;
		if(ice_get_option( 'dpd_auto_monday', 'dpd_options' ) == '1' and $is_weekend)
			{
				$default_ship_date = date('Y-m-d', strtotime('next monday'));
			}

		echo '<label for="ship-date">Shipping Date: </label>';
		echo '<input type="text" name="ship_date" value="'.$default_ship_date.'" class="ship_date_cls_de" id="ship-date" />';
		echo '<br /><Br />';
		echo '<label for="dpd-content">Parcel Content Description: </label>';
		echo '<input type="text" name=""dpd_content" value="'.ice_get_option( 'dpd_content', 'dpd_options' ).'" id="dpd-content" ';
		
		echo '<br><br><br>';

		echo '<input type="checkbox" name="disable_order_completion" value="1" />';
		echo '<label for="disable_order_completion">Disable Order Completion</label>';

		echo '<Br /><br /><br />';
		echo '<div class="create-shipping-label button button-primary" id="shipping_order-'.$order_id.'">Create Shipping Label</div>';
		echo '<div class="shipping-label-in-process" style="display:none;">Shipping Label is being created...</div>';
	}
	else {
		echo 'Shippig Label could not be deleted.';
	}
		die();
}
	
	

add_action( 'before_delete_post', 'delete_dpd_order' );
function delete_dpd_order( $postid ){
    // We check if the global post type isn't ours and just return
    global $post_type;   
    if ( $post_type != 'shop_order' ) return;
	else {
		global $wpdb;
		$table_name = $wpdb->prefix.'dpd_orders';
		$wpdb->delete($table_name,array('order_id' => $postid));
	}
}

add_action('woocommerce_email_order_details','show_tracking_number',10,4);
function show_tracking_number($order, $sent_to_admin, $plain_text, $email){
	global $wpdb;
	$table_name = $wpdb->prefix.'dpd_orders';
	$order_id = $order->get_id();
	$parcels = $wpdb->get_results("Select parcel_number FROM $table_name WHERE order_id = $order_id AND status LIKE 'publish' ORDER BY id DESC");
	if( count ( $parcels ) ){
		$parc_num = $parcels[0]->parcel_number;
		$shipping_date = $wpdb->get_row("Select shipping_date FROM $table_name WHERE parcel_number = '$parc_num'");
		$formatted_shiiping_date = date('d.m.Y', absint($shipping_date->shipping_date));
		printf(
			/* translators: %s: Formatted shipping date */
			__( 'Die Bestellung wird am %s mit DPD verschickt. Hier der Link um die Sendung zu verfolgen: ', 'dpd-shipping-label' ),
			$formatted_shiiping_date
		);
		foreach ( $parcels as $parcel ) {
			echo '<a href="https://tracking.dpd.de/parcelstatus?query='.$parcel->parcel_number.'&locale=de_DE" target="_blank">'.$parcel->parcel_number.'</a>';
			echo '<br /><br />';
		}
	}
}

add_action('woocommerce_checkout_process', 'checkbox_custom_checkout_process'); 
function checkbox_custom_checkout_process() {
global $woocommerce;	
	$dpd_must_house_number = ice_get_option( 'dpd_must_house_number', 'dpd_options' );	
	
	if( isset($_POST['ship_to_different_address']) and $_POST['ship_to_different_address'] == '1' ){
		if (strcspn($_POST['shipping_address_1'], '0123456789') != strlen($_POST['shipping_address_1'])){
		
		}
		elseif($dpd_must_house_number){
			wc_add_notice( __( 'Haben Sie die Hausnummer bei der StraÃŸe vergessen?' ), 'error' );
		}

		if(!( preg_match("/[a-z]/i", $_POST['shipping_address_1']) or preg_match("/[a-z]/i", $_POST['shipping_address_2'])  )){
			if($dpd_must_house_number){
				wc_add_notice( __( 'Street name in the address field is required.' ), 'error' );
			}
		}
	}
	else{
		if (strcspn($_POST['billing_address_1'], '0123456789') != strlen($_POST['billing_address_1'])){
		
		}
		elseif($dpd_must_house_number){
			wc_add_notice( __( 'Haben Sie die Hausnummer bei der StraÃŸe vergessen?' ), 'error' );
		}

		if(!( preg_match("/[a-z]/i", $_POST['billing_address_1']) or preg_match("/[a-z]/i", $_POST['billing_address_2'])  )){
			if($dpd_must_house_number){
				wc_add_notice( __( 'Street name in the address field is required.' ), 'error' );
			}
		}
	}
}

function dpd_add_tracking_actions( $actions, $order ) {
	global $wpdb;
	$table_name = $wpdb->prefix.'dpd_orders';
	$order_id = $order->get_id();
	$parcels = $wpdb->get_results("Select parcel_number FROM $table_name WHERE order_id = $order_id AND status LIKE 'publish'");
	if( count ( $parcels ) ){
		$parc_num = $parcels[0]->parcel_number;
		$shipping_date = $wpdb->get_row("Select shipping_date FROM $table_name WHERE parcel_number = '$parc_num'");
		foreach ( $parcels as $parcel ) {
			$actions['name'] = array(
				'url'  => 'https://tracking.dpd.de/parcelstatus?query='.$parcel->parcel_number.'&locale=de_DE',
				'name' => 'Tracking',
			);			
		}
	}
	return $actions;
}
add_filter( 'woocommerce_my_account_my_orders_actions', 'dpd_add_tracking_actions', 10, 2 );


// Download Shipping labels depending on date range
add_action('wp', 'download_shipping_labels_date_range');
function download_shipping_labels_date_range(){
	if (isset($_GET['download_shipping_list']) && $_GET['download_shipping_list'] && is_user_logged_in() && current_user_can('edit_posts')) {
		global $wpdb;
		$fromDate = strtotime( $_GET['download_from_shipping_date'].' 00:00:01' ) - 10;
		$toDate = strtotime( $_GET['download_to_shipping_date'].' 23:59:59' ) + 10;
		
		$table_name = $wpdb->prefix.'dpd_orders';
		$q_order_labels = "SELECT * FROM $table_name WHERE shipping_date >= $fromDate and shipping_date <= $toDate AND status LIKE 'publish' ORDER BY id DESC";
		$dpdorders = $wpdb->get_results($q_order_labels);		
		
		$j = 0;
		if ( count ( $dpdorders ) > 0 ) {
			foreach($dpdorders as $dpdorder){
				$order = wc_get_order($dpdorder->order_id);
				$j++;
			}
		}
		
		require_once __DIR__ . '/mpdf/vendor/autoload.php';
		$mpdf = new \Mpdf\Mpdf([
					'mode' => 'c',
					'format' => 'A4',
					'mgl' => '0',
					'mgr' => '0'
				]);
		$mpdf->SetDisplayMode('fullpage');
		$mpdf->list_indent_first_level = 0;  // 1 or 0 - whether to indent the first level of a list
		$mpdf->AddPage();
		$mpdf->defaultfooterfontsize=10;
		$mpdf->defaultfooterfontstyle='BI';
		$mpdf->defaultfooterline=0;
		$footer = '
			<div style="width:92%;margin-left:auto;margin-right:auto;font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;">
				<div style="float:left;width:50%;">
					UnterschriftÂ Â Â  _______________
				</div>
				<div style="float:right;width:50%;text-align:right;">
					Seite {PAGENO} von {nbpg}
				</div>
			</div>
		';
		$mpdf->SetHTMLFooter($footer);
		$html = '
	
		<style>
			.container {
				width:92%;
				margin-left:auto;
				margin-right:auto;
			}
			.top-header {
			overflow:hidden;
			font-size:13px;
			font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
			}
			.header-column {
			width:30%;
			display:inline-block;
			float:left;
			}
			.header-column img {
			float:right;
			}
			.column-down {
			margin-top:38px;
			}
			.content {
			margin-top:100px;
			width:100%;
			}
			.content table, .content table tr, .content table thead, .content table tbody {
			width:100%;
			}
			
			.norm_td {
			}
			
			td {
			font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
			font-size:11px;
			}
			
			table th {
			font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
			text-align:left;
			border-bottom:2px solid black;
			}
			.address {
			}
		</style>
		

		<div class="container">
			<div class="inn-con">
				<header class="top-header"> 
					<div class="first-column header-column">
						<span>
							<div>Kundenadresse</div>
							<div>'.ice_get_option('dpd_sender_name','dpd_options').'</div>
							<div>'.ice_get_option('dpd_sender_street','dpd_options').'</div>
							<div>'.ice_get_option('dpd_sender_country','dpd_options').'-'.ice_get_option('dpd_sender_zipcode','dpd_options').' '.ice_get_option('dpd_sender_city','dpd_options').'</div>
						</span>
					</div>
					<!-- <div class="second-column header-column">
						<span>
							<div>Depotadresse</div>
							<div>Depot 0166</div>
							<div>DPD GeoPost (Deutschland) GmbH</div>
							<div>Suedstrasse 51</div>
							<div>DE-66386 St. Ingber</div>
						</span>
					</div> -->
					<div class="third-column header-column" style="text-align:right;padding-right:20px;">
						<span>
							<!-- <div>Versandliste Nr. 353</div> -->
							<div>Datum: '.gmdate ( 'd-m-Y H:i:s', strtotime ( get_option ( 'gmt_offset' ).' hours' ) ).'</div>
							<div>Anzahl Pakete: '.$j.'</div>
						</span>
					</div>
					<div class="forth-column header-column">
						<img src="'.plugin_dir_url( __FILE__ ).'logo.png" width="100%" style="margin-left:40px;float:right;clear:both;"/>
						<!-- <div class="column-down" style="clear:both;">
							<div>MyDPD Pro</div>
							<div>Routentabellen Version 2016050</div>
						</div> -->
					</div>
					
				</header>
				
				<div class="content">
					<table style="width:100%;">
							<tr>
								<th><strong>Nr.</strong></th>
								<th><strong>Paket-Nr.</strong></th>
								<!-- <th><strong>Versandart</strong></th> -->
								<th><strong>Empfanger</strong></th>
								<!-- <th><strong>Erfasser</strong></th> -->
								<th><strong>Referenznummer</strong></th>
								<th><strong>Kg</strong></th>
							</tr>

						<tbody>
						';
						
						
						$i = 1;
						if ( count ( $dpdorders ) > 0 ) {
						foreach($dpdorders as $dpdorder){
							$order = wc_get_order($dpdorder->order_id);
							if ( !empty($order) && $dpdorder->shipping_date && $dpdorder->shipping_date != null ) {

								$address = $order->get_shipping_first_name().' '.$order->get_shipping_last_name().', '.$order->get_shipping_company().', ';
								$address .= $order->get_shipping_address_1();
								$address .= ', '.$order->get_shipping_postcode();
								$address .= ', '.$order->get_shipping_city();
								$address .= ', '.$order->get_shipping_country();
								$address = strlen ( $address ) > 50 ? substr( $address, 0 , 75 ) : $address;
								$html .= '<tr>';
								$html .= '<td width="3%">'.$i.'</td>';
								$html .= '<td width="15%">'.$dpdorder->parcel_number.'</td>';
								$html .= '<td width="70%">'.$address.'</td>';
								$html .= '<td width="5%">'.$dpdorder->order_id.'</td>';
								$html .= '<td width="7%">'.$dpdorder->weight.'</td>';
								$html .=' </tr>';
								$i++;
							}
						}
						}
						
						$html .= '</tbody>
						</table>
						</div>	
						</div>
		</div>
	';
	$html = mb_convert_encoding($html, 'UTF-8', 'UTF-8');
	$mpdf->WriteHTML($html);
	
	$mpdf->Output('Shipping_list.pdf','I');
	exit;
		
	} elseif(isset($_GET['download_shipping_labels']) && $_GET['download_shipping_labels'] && is_user_logged_in() && current_user_can('edit_posts')){
		global $wpdb;
		$fromDate = strtotime( $_GET['download_from_shipping_date'] ) - 10;
		$toDate = strtotime( $_GET['download_to_shipping_date'] ) + 10;

		$table_name = $wpdb->prefix.'dpd_orders';
		$q_order_labels = "SELECT * FROM $table_name WHERE shipping_date >= $fromDate and shipping_date <= $toDate AND status LIKE 'publish'";
		$dpdorders = $wpdb->get_results($q_order_labels);

		$j = 0;
		if ( count ( $dpdorders ) > 0 ) {
			__dpd_download_bulk_labels($dpdorders);
		} else {
			echo "<h2>No Orders found shipped between the selected date period!</h2>";
			exit;
		}
	}
}

add_action('wp_head', 'target_blank_for_tracking');
function target_blank_for_tracking(){
	?>
	<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery('.order-actions a:nth-child(2)').attr("target", "_blank");
		});
	</script>
	<?php
}

add_filter( 'plugin_row_meta', 'dpd_custom_plugin_row_meta', 10, 2 );
function dpd_custom_plugin_row_meta($links, $file){
	if(plugin_basename(__FILE__) == $file){
  	$row_meta = array(
				'dpd_docs'    => '<a href="https://goo.gl/WLZKsj" target="_blank">' . esc_html__( 'Dokumentation', 'dpd-shipping-label' ) . '</a>',
				'dpd_support' => '<a href="mailto:info@emoose.de">' . esc_html__( 'Mail-Support', 'dpd-shipping-label' ) . '</a>',
				'dpd_report' => '<a href="https://www.emoose.de/problemmeldung-dpd-plugin/" target="_blank">' . esc_html__( 'Fehler melden', 'dpd-shipping-label' ) . '</a>',
			);

			return array_merge( $links, $row_meta );
  }
  return $links;
}

add_action('woocommerce_admin_order_actions', 'add_dpd_order_action', 10, 2);
add_filter('woocommerce_admin_order_preview_actions', 'add_dpd_order_action', 10, 2);  // WC 3.3
function add_dpd_order_action($actions, $order){
	global $wpdb;
	$table_name = $wpdb->prefix.'dpd_orders';
	$order_id = $order->get_id();
	$order = $wpdb->get_row("SELECT * FROM $table_name WHERE order_id = $order_id");
	if(!$order){
		if(get_post_meta($order_id, 'dpd_error', true) == '1'){
			$actions['dpd_label_error'] = array(
				'url'	=> admin_url('post.php?post='.$order_id.'&action=edit'),
				'name'	=> 'Could not craete DPD label',
				'action'	=> 'dpd_label_error'
			);
		}
		else{
			$actions['create_dpd_label'] = array(
				'url'	=> admin_url('post.php?post='.$order_id.'&action=edit'),
				'name'	=> 'Create DPD Label',
				'action'	=> 'create_dpd_label'
			);
		}
	}
	return $actions;
}

add_action('admin_footer', 'dpd_order_action_style', 1000);
function dpd_order_action_style(){
	?>
	<style>
		a.button.create_dpd_label{
			background-image: url(<?php echo plugin_dir_url(__FILE__).'images/dpd.jpg'; ?>) !important; 
			background-color: transparent;
    border: 0;
    box-shadow: none;
    width: 26px;
    height: 26px;
    margin: 0 4px 2px 0;
    background-size: cover;
    content: ' ';
    text-indent: -9999999px;
		}
		a.button.dpd_label_error{
			background-image: url(<?php echo plugin_dir_url(__FILE__).'images/dpd-error.png'; ?>) !important; 
			background-color: transparent;
    border: 0;
    box-shadow: none;
    width: 26px;
    height: 26px;
    margin: 0 4px 2px 0;
    background-size: cover;
    content: ' ';
    text-indent: -9999999px;
		}

		a.button.create_dpd_label:hover{ 
			background: round !important;
			background-image: url(<?php echo plugin_dir_url(__FILE__).'images/dpd.jpg'; ?>) !important;
		}
		a.button.dpd_label_error:hover{
			background: round !important;
			background-image: url(<?php echo plugin_dir_url(__FILE__).'images/dpd-error.png'; ?>) !important;
		}
		

	</style>
	<?php
}

class DPD_notify {
    private $_message;

    function __construct( $message, $type ) {
        $this->_message = $message;
		$this->_type = $type;

        add_action( 'admin_notices', array( $this, 'render' ) );
    }

    function render() {
        printf( '<div class="%s">%s</div>', $this->_type, $this->_message );
    }
}

// Adding to admin order list bulk dropdown a custom action 'custom_downloads'
// Register bulk actions
add_filter( 'bulk_actions-edit-shop_order', 'dpd_bulk_generate_labels_classic' );
add_filter( 'bulk_actions-woocommerce_page_wc-orders', 'dpd_bulk_generate_labels_hpos' );

function dpd_bulk_generate_labels_classic( $actions ) {
    $actions['dpd_bulk_create_label'] = __( 'Create Shipping Label', 'woocommerce' );
    return $actions;
}

function dpd_bulk_generate_labels_hpos( $actions ) {
    $actions['dpd_bulk_create_label'] = __( 'Create Shipping Label', 'woocommerce' );
    return $actions;
}

// Handle bulk actions
add_filter( 'handle_bulk_actions-edit-shop_order', 'dpd_handle_bulk_generate_labels', 10, 3 );
add_filter( 'handle_bulk_actions-woocommerce_page_wc-orders', 'dpd_handle_bulk_generate_labels', 10, 3 );

function dpd_handle_bulk_generate_labels( $redirect_to, $action, $post_ids ) {
    if ( $action !== 'dpd_bulk_create_label' ) {
        return $redirect_to;
    }

    $success_ids = array();
    $failed_ids  = array();

    foreach ( $post_ids as $post_id ) {
        $response_error = create_label( $post_id, 'return' );
        if ( ! $response_error ) {
            $success_ids[] = $post_id;
        } else {
            $failed_ids[] = $post_id;
        }
    }

    return add_query_arg( array(
        'sids' => implode( ',', $success_ids ),
        'fids' => implode( ',', $failed_ids ),
    ), $redirect_to );
}

function dpd_label_on_order_status_completed( $order_id ) 
	{ 
		$auto_generate_shipping_label = ice_get_option( 'dpd_auto_generate_shipping_label_oc', 'dpd_options' );
		if($auto_generate_shipping_label)	create_label($order_id, 'return');
	}
add_action( 'woocommerce_order_status_completed', 'dpd_label_on_order_status_completed', 10, 1 );

function dpd_label_on_order_status_processing( $order_id ) 
	{ 
		$auto_generate_shipping_label = ice_get_option( 'dpd_auto_generate_shipping_label_op', 'dpd_options' );
		if($auto_generate_shipping_label)	create_label($order_id, 'return');
	}
add_action( 'woocommerce_order_status_processing', 'dpd_label_on_order_status_processing', 10, 1 );

function get_order_shipping_label_number($order_id, $return = 'label_number')
	{
		$label_numbers = array();
		$label_numbers_string = '';
		if( $order_id and is_numeric($order_id) )
			{
				global $wpdb;
				$table_name = $wpdb->prefix.'dpd_orders';
				$parcels = $wpdb->get_results("SELECT id, parcel_number, date FROM $table_name WHERE order_id = $order_id AND (order_type != 'amazon_prime' OR order_type IS NULL ) AND status !='trash'");
				if( count ( $parcels ) > 0 ) {
					foreach($parcels as $parcel){
						if(isset($parcel->id) and $return == 'parcel_number'){
							$label_numbers[] = $parcel->parcel_number;
						} elseif(isset($parcel->id) and $return == 'tracking_links') {
							$tracking_url = str_replace("PARCEL_NUMBER",$parcel->parcel_number,DPD_TRACKING_URL);
							$label_numbers[] = '<a href="'.$tracking_url.'" target="_blank">'.$parcel->parcel_number.'</a>';
						} elseif(isset($parcel->id) and $return == 'download_links') {
							$label_numbers[] = '<a href="'.get_home_url().'/?dpd_id='.$parcel->id.'" target="_blank">Download PDF</a>';	
						} elseif(isset($parcel->id)) {
							$label_numbers[] = $parcel->id;	
						}	
					}
				}	
			}
		if(is_array($label_numbers) and sizeof($label_numbers)){
			$label_numbers_string = implode(", ", $label_numbers);
		}
		return $label_numbers_string;
	}

// The results notice from bulk action on orders
add_action( 'admin_notices', 'downloads_bulk_action_admin_notice' );
function downloads_bulk_action_admin_notice() {
	$success_ids = '';	if(isset($_REQUEST['sids']))	$success_ids = $_REQUEST['sids'];
	$failed_ids = '';	if(isset($_REQUEST['fids']))	$failed_ids = $_REQUEST['fids'];
	
	if($success_ids)
		{
			echo '<div class="notice notice-success"><br>';
			echo "Successfully generated label for the following Orders: ";
			$success_ids_array = explode(",", $success_ids);
			if(is_array($success_ids_array) and sizeof($success_ids_array))
				{
					foreach($success_ids_array as $success_id)
						{
							$label_numbers = get_order_shipping_label_number($success_id, 'download_links');
							echo '<br>Order ID: '.$success_id.' - '.$label_numbers;
							//echo '<br>Order ID: '.$success_id.' - <a href="'.get_home_url().'/?dpd_id='.$label_number.'" target="_blank">Click here to download PDF</a>';
						}
				}
			echo '<br><br></div>';
		}
		
	if($failed_ids)
		{
			echo "<br>Failed generating Labels for following Order numbers: ".$failed_ids;
		}
}

function dpd_wc_add_label_pdf_column_header( $columns ) {
    $new_columns = array();
    foreach ( $columns as $column_name => $column_info ) {
        $new_columns[ $column_name ] = $column_info;
        if ( 'order_total' === $column_name ) {
            $new_columns['shipping_label'] = __( 'Shipping Label', 'my-textdomain' );
        }
    }
    return $new_columns;
}
add_filter( 'manage_edit-shop_order_columns', 'dpd_wc_add_label_pdf_column_header', 20 );
add_filter( 'manage_woocommerce_page_wc-orders_columns', 'dpd_wc_add_label_pdf_column_header', 20 );

function dpd_wc_add_label_pdf_column_content( $column, $order=array()) {
    $screen = get_current_screen();
	if( $screen->id == 'woocommerce_page_wc-orders' ){
     if ( 'shipping_label' === $column ) {
    		$label_numbers = get_order_shipping_label_number($order->ID, 'download_links');
    		if($label_numbers)	echo $label_numbers;
    
    		$parcel_numbers = get_order_shipping_label_number($order->ID, 'tracking_links');
            if($parcel_numbers) echo '&nbsp;|&nbsp;'.$parcel_numbers;
    }
	}else{
	     global $post;
	      if ( 'shipping_label' === $column ) {
    		$label_numbers = get_order_shipping_label_number($post->ID, 'download_links');
    		if($label_numbers)	echo $label_numbers;
    
    		$parcel_numbers = get_order_shipping_label_number($post->ID, 'tracking_links');
            if($parcel_numbers) echo '&nbsp;|&nbsp;'.$parcel_numbers;
        }
	}
}

add_action( 'manage_shop_order_posts_custom_column', 'dpd_wc_add_label_pdf_column_content' );

add_action( 'manage_woocommerce_page_wc-orders_custom_column', 'dpd_wc_add_label_pdf_column_content', 10, 2 );

function dpd_email_parcel_number_placeholder( $string, $email ) 
	{
		global $wpdb;
		$placeholder = '{parcel_number}';
		if(isset($email->object)){
			$order = $email->object;
			if( is_a( $order, 'WC_Order' ) ) {
				$order_id = $order->get_id();
				if($order_id) {
					$table_name = $wpdb->prefix . 'dpd_orders';		
					$parcel_number = $wpdb->get_var("SELECT parcel_number FROM $table_name WHERE order_id = $order_id AND status LIKE 'publish'");
					$string = str_replace( $placeholder, $parcel_number, $string );
				}
			}
		}	
		return $string;	
	}
add_filter( 'woocommerce_email_format_string' , 'dpd_email_parcel_number_placeholder', 10, 2 );

function dpd_parcel_number_sc($atts = array())
	{
		$order_id = '';	if(isset($atts['order_id']) and $atts['order_id'] and is_numeric($atts['order_id']))	$order_id = $atts['order_id'];
		$parcel_number = '';
		if($order_id)
			{
				global $wpdb;
				$table_name = $wpdb->prefix . 'dpd_orders';		
				$parcel_number = $wpdb->get_var("SELECT parcel_number FROM $table_name WHERE order_id = $order_id AND status LIKE 'publish'");
			}
		return $parcel_number;
	}
add_shortcode('DPD_PARCEL_NUMBER','dpd_parcel_number_sc');

function dpd_woocommerce_search_parcel_number( $search_fields ) {
	$search_fields[] = 'dpd_parcel_number';  
	return $search_fields;
}
add_filter( 'woocommerce_shop_order_search_fields', 'dpd_woocommerce_search_parcel_number' );

function __dpd_download_bulk_labels($dpdorders){
	$upload_dir   = wp_upload_dir();
	$zip_name_prefix = rand(10,1000);
	$zip_name = $zip_name_prefix.'-'.time().".zip";
	$zip = new ZipArchive;
	$res = $zip->open($zip_name, ZipArchive::CREATE);
	if ($res === TRUE) {
		$count = 1;
		foreach($dpdorders as $dpdorder){
			$pdf_data = $dpdorder->pdf_data;
			if($pdf_data){
				$decoded_data = base64_decode($pdf_data);
				$file_name = 'parcel-'.$count.'.pdf';
				if($dpdorder->parcel_number){
					$file_name = $dpdorder->parcel_number.'-'.$count.'.pdf';
				}
				$zip->addFromString($file_name, $decoded_data);            
				$count++;
			}
		}
		$zip->close();
		if(file_exists($zip_name))
			{
				header('Content-type: application/zip');
				header('Content-Disposition: attachment; filename="'.$zip_name.'"');
				readfile($zip_name);
				unlink($zip_name);
				exit;
			}
	}
}

function dpd_register_bulk_labels_download( $bulk_actions ) {
	$bulk_actions['dpd-bulk-labels-download'] = __( 'Download DPD Shipping Labels', 'dpd-shipping-label' );
	return $bulk_actions;
}
add_filter( 'bulk_actions-edit-shop_order', 'dpd_register_bulk_labels_download' );


function dpd_bulk_labels_download_handler( $redirect_to, $action, $post_ids ) {
	global $wpdb;
	if ( ! in_array($action, array('dpd-bulk-labels-download'))) {
		return $redirect_to;
	}
	$post_ids_list = implode(", ", $post_ids);
	$table_name = $wpdb->prefix.'dpd_orders';
	$q_order_labels = "SELECT * FROM $table_name WHERE order_id IN (".$post_ids_list.") AND status !='trash' ";	
	$dpdorders = $wpdb->get_results($q_order_labels);
	if ( count ( $dpdorders ) > 0 ) {
		__dpd_download_bulk_labels($dpdorders);
	}
	return $redirect_to;
}
add_filter( 'handle_bulk_actions-edit-shop_order', 'dpd_bulk_labels_download_handler', 10, 3 );
/* compatibility code add here  */
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

?>