<?php
require_once( dirname(__FILE__) . '/wp-load.php' );

if (!current_user_can('manage_woocommerce')) {
    wp_die('Nu ai permisiunea să accesezi această pagină.');
}

echo "<pre>";

$tz = wp_timezone();
$now = new DateTime('now', $tz);
$zi_param = isset($_GET['zi']) ? $_GET['zi'] : null;

try {
    if ($zi_param) {
        // Dacă ziua este furnizată manual
        $start_local = new DateTime($zi_param, $tz);
        $start_local->setTime(5, 0, 0);
        $end_local = (clone $start_local)->modify('+1 day')->setTime(4, 59, 59);
    } else {
        // Fără zi specificată → determinăm în funcție de ora actuală
        if ((int)$now->format('H') >= 5) {
            $start_local = (clone $now)->setTime(5, 0, 0);
            $end_local = (clone $now)->modify('+1 day')->setTime(4, 59, 59);
        } else {
            $start_local = (clone $now)->modify('-1 day')->setTime(5, 0, 0);
            $end_local = (clone $now)->setTime(4, 59, 59);
        }
    }
} catch (Exception $e) {
    wp_die("Dată invalidă: " . $e->getMessage());
}

// Conversie în UTC pentru query
$start_utc = (clone $start_local)->setTimezone(new DateTimeZone('UTC'));
$end_utc = (clone $end_local)->setTimezone(new DateTimeZone('UTC'));

// Afișare interval
echo "🕒 Interval analizat (ora locală): " . $start_local->format('Y-m-d H:i:s') . " → " . $end_local->format('Y-m-d H:i:s') . "\n";
echo "🌐 Interval efectiv (UTC):         " . $start_utc->format('Y-m-d H:i:s') . " → " . $end_utc->format('Y-m-d H:i:s') . "\n\n";

// Căutăm comenzile
$args = [
    'limit' => -1,
    'status' => ['processing'],
    'date_created' => $start_utc->format('Y-m-d H:i:s') . '...' . $end_utc->format('Y-m-d H:i:s'),
    'type' => 'shop_order',
    'exclude' => wc_get_orders(['status' => 'trash', 'return' => 'ids']),
];

$orders = wc_get_orders($args);
$total_caserole = 0;

if (empty($orders)) {
    echo "⚠️ Nu s-au găsit comenzi în acest interval.\n";
} else {
    foreach ($orders as $order) {
        $order_id = $order->get_id();
        $order_date = $order->get_date_created()->setTimezone($tz)->format('Y-m-d H:i');
        $order_total = 0;

        echo "🧾 Comanda #$order_id ($order_date)\n";

        foreach ($order->get_items() as $item) {
            if (!is_a($item, 'WC_Order_Item_Product')) continue;

            $qty = $item->get_quantity();
            echo "- " . $item->get_name() . " × $qty\n";
            $order_total += $qty;
        }

        echo "Subtotal caserole comandă: $order_total\n\n";
        $total_caserole += $order_total;
    }
}

$total_gheata = $total_caserole * 0.5;

echo "=== REZUMAT ===\n";
echo "📦 Total caserole: $total_caserole\n";
echo "❄️  Total gheață necesară: $total_gheata kg\n";
echo "</pre>";
